/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.evm;

import io.horizen.evm.LibEvmCallback;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CallbackRegistry {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<Integer, LibEvmCallback> callbacks = new HashMap<Integer, LibEvmCallback>();

    private CallbackRegistry() {
    }

    static synchronized int register(LibEvmCallback callback) {
        for (int handle = 0; handle <= callbacks.size(); ++handle) {
            if (callbacks.containsKey(handle)) continue;
            callbacks.put(handle, callback);
            logger.trace("registered callback with handle {}: {}", (Object)handle, (Object)callback);
            return handle;
        }
        throw new IllegalStateException("too many callback handles");
    }

    static synchronized void unregister(int handle, LibEvmCallback callback) {
        if (!callbacks.remove(handle, callback)) {
            logger.warn("already unregistered callback with handle {}: {}", (Object)handle, (Object)callback);
            return;
        }
        logger.trace("unregistered callback with handle {}: {}", (Object)handle, (Object)callback);
    }

    static synchronized LibEvmCallback get(int handle) {
        if (!callbacks.containsKey(handle)) {
            logger.warn("received callback with invalid handle: {}", (Object)handle);
            return null;
        }
        return callbacks.get(handle);
    }
}

