/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.BinaryLog;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Deadline;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalLogId;
import io.grpc.InternalServerInterceptors;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.Status;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.CallTracer;
import io.grpc.internal.ContextRunnable;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.ServerCallImpl;
import io.grpc.internal.ServerCallInfoImpl;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.StreamListener;
import io.perfmark.Link;
import io.perfmark.PerfMark;
import io.perfmark.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public final class ServerImpl
extends Server
implements InternalInstrumented<InternalChannelz.ServerStats> {
    private static final Logger log = Logger.getLogger(ServerImpl.class.getName());
    private static final ServerStreamListener NOOP_LISTENER = new NoopListener();
    private final InternalLogId logId;
    private final ObjectPool<? extends Executor> executorPool;
    private Executor executor;
    private final HandlerRegistry registry;
    private final HandlerRegistry fallbackRegistry;
    private final List<ServerTransportFilter> transportFilters;
    private final ServerInterceptor[] interceptors;
    private final long handshakeTimeoutMillis;
    @GuardedBy(value="lock")
    private boolean started;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @GuardedBy(value="lock")
    private Status shutdownNowStatus;
    @GuardedBy(value="lock")
    private boolean serverShutdownCallbackInvoked;
    @GuardedBy(value="lock")
    private boolean terminated;
    private final List<? extends InternalServer> transportServers;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean transportServersTerminated;
    @GuardedBy(value="lock")
    private final Set<ServerTransport> transports = new HashSet<ServerTransport>();
    @GuardedBy(value="lock")
    private int activeTransportServers;
    private final Context rootContext;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final BinaryLog binlog;
    private final InternalChannelz channelz;
    private final CallTracer serverCallTracer;
    private final Deadline.Ticker ticker;

    ServerImpl(AbstractServerImplBuilder<?> builder, List<? extends InternalServer> transportServers, Context rootContext) {
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(builder.executorPool, (Object)"executorPool");
        this.registry = (HandlerRegistry)Preconditions.checkNotNull((Object)((Object)builder.registryBuilder.build()), (Object)"registryBuilder");
        this.fallbackRegistry = (HandlerRegistry)Preconditions.checkNotNull((Object)builder.fallbackRegistry, (Object)"fallbackRegistry");
        Preconditions.checkNotNull(transportServers, (Object)"transportServers");
        Preconditions.checkArgument((!transportServers.isEmpty() ? 1 : 0) != 0, (Object)"no servers provided");
        this.transportServers = new ArrayList<InternalServer>(transportServers);
        this.logId = InternalLogId.allocate((String)"Server", (String)String.valueOf(this.getListenSocketsIgnoringLifecycle()));
        this.rootContext = ((Context)Preconditions.checkNotNull((Object)rootContext, (Object)"rootContext")).fork();
        this.decompressorRegistry = builder.decompressorRegistry;
        this.compressorRegistry = builder.compressorRegistry;
        this.transportFilters = Collections.unmodifiableList(new ArrayList<ServerTransportFilter>(builder.transportFilters));
        this.interceptors = builder.interceptors.toArray(new ServerInterceptor[builder.interceptors.size()]);
        this.handshakeTimeoutMillis = builder.handshakeTimeoutMillis;
        this.binlog = builder.binlog;
        this.channelz = builder.channelz;
        this.serverCallTracer = builder.callTracerFactory.create();
        this.ticker = (Deadline.Ticker)Preconditions.checkNotNull((Object)builder.ticker, (Object)"ticker");
        this.channelz.addServer((InternalInstrumented)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerImpl start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Already started");
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"Shutting down");
            ServerListenerImpl listener = new ServerListenerImpl();
            for (InternalServer internalServer : this.transportServers) {
                internalServer.start(listener);
                ++this.activeTransportServers;
            }
            this.executor = (Executor)Preconditions.checkNotNull((Object)this.executorPool.getObject(), (Object)"executor");
            this.started = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"Not started");
            Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"Already terminated");
            for (InternalServer internalServer : this.transportServers) {
                SocketAddress addr = internalServer.getListenSocketAddress();
                if (!(addr instanceof InetSocketAddress)) continue;
                return ((InetSocketAddress)addr).getPort();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocketAddress> getListenSockets() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"Not started");
            Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"Already terminated");
            return this.getListenSocketsIgnoringLifecycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SocketAddress> getListenSocketsIgnoringLifecycle() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>(this.transportServers.size());
            for (InternalServer internalServer : this.transportServers) {
                addrs.add(internalServer.getListenSocketAddress());
            }
            return Collections.unmodifiableList(addrs);
        }
    }

    public List<ServerServiceDefinition> getServices() {
        List fallbackServices = this.fallbackRegistry.getServices();
        if (fallbackServices.isEmpty()) {
            return this.registry.getServices();
        }
        List registryServices = this.registry.getServices();
        int servicesCount = registryServices.size() + fallbackServices.size();
        ArrayList services = new ArrayList(servicesCount);
        services.addAll(registryServices);
        services.addAll(fallbackServices);
        return Collections.unmodifiableList(services);
    }

    public List<ServerServiceDefinition> getImmutableServices() {
        return this.registry.getServices();
    }

    public List<ServerServiceDefinition> getMutableServices() {
        return Collections.unmodifiableList(this.fallbackRegistry.getServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerImpl shutdown() {
        boolean shutdownTransportServers;
        Iterator<? extends InternalServer> iterator = this.lock;
        synchronized (iterator) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            shutdownTransportServers = this.started;
            if (!shutdownTransportServers) {
                this.transportServersTerminated = true;
                this.checkForTermination();
            }
        }
        if (shutdownTransportServers) {
            for (InternalServer internalServer : this.transportServers) {
                internalServer.shutdown();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerImpl shutdownNow() {
        boolean savedServerShutdownCallbackInvoked;
        ArrayList<ServerTransport> transportsCopy;
        this.shutdown();
        Status nowStatus = Status.UNAVAILABLE.withDescription("Server shutdownNow invoked");
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.shutdownNowStatus != null) {
                return this;
            }
            this.shutdownNowStatus = nowStatus;
            transportsCopy = new ArrayList<ServerTransport>(this.transports);
            savedServerShutdownCallbackInvoked = this.serverShutdownCallbackInvoked;
        }
        if (savedServerShutdownCallbackInvoked) {
            for (ServerTransport transport : transportsCopy) {
                transport.shutdownNow(nowStatus);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.terminated) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transportClosed(ServerTransport transport) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.transports.remove(transport)) {
                throw new AssertionError((Object)"Transport already removed");
            }
            this.channelz.removeServerSocket((InternalInstrumented)this, (InternalInstrumented)transport);
            this.checkForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTermination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown && this.transports.isEmpty() && this.transportServersTerminated) {
                if (this.terminated) {
                    throw new AssertionError((Object)"Server already terminated");
                }
                this.terminated = true;
                this.channelz.removeServer((InternalInstrumented)this);
                if (this.executor != null) {
                    this.executor = this.executorPool.returnObject(this.executor);
                }
                this.lock.notifyAll();
            }
        }
    }

    public InternalLogId getLogId() {
        return this.logId;
    }

    public ListenableFuture<InternalChannelz.ServerStats> getStats() {
        InternalChannelz.ServerStats.Builder builder = new InternalChannelz.ServerStats.Builder();
        for (InternalServer internalServer : this.transportServers) {
            InternalInstrumented<InternalChannelz.SocketStats> stats = internalServer.getListenSocketStats();
            if (stats == null) continue;
            builder.addListenSockets(Collections.singletonList(stats));
        }
        this.serverCallTracer.updateBuilder(builder);
        SettableFuture ret = SettableFuture.create();
        ret.set((Object)builder.build());
        return ret;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("logId", this.logId.getId()).add("transportServers", this.transportServers).toString();
    }

    @VisibleForTesting
    static final class ContextCloser
    implements Runnable {
        private final Context.CancellableContext context;
        private final Throwable cause;

        ContextCloser(Context.CancellableContext context, Throwable cause) {
            this.context = context;
            this.cause = cause;
        }

        @Override
        public void run() {
            this.context.cancel(this.cause);
        }
    }

    @VisibleForTesting
    static final class JumpToApplicationThreadServerStreamListener
    implements ServerStreamListener {
        private final Executor callExecutor;
        private final Executor cancelExecutor;
        private final Context.CancellableContext context;
        private final ServerStream stream;
        private final Tag tag;
        private ServerStreamListener listener;

        public JumpToApplicationThreadServerStreamListener(Executor executor, Executor cancelExecutor, ServerStream stream, Context.CancellableContext context, Tag tag) {
            this.callExecutor = executor;
            this.cancelExecutor = cancelExecutor;
            this.stream = stream;
            this.context = context;
            this.tag = tag;
        }

        private ServerStreamListener getListener() {
            if (this.listener == null) {
                throw new IllegalStateException("listener unset");
            }
            return this.listener;
        }

        @VisibleForTesting
        void setListener(ServerStreamListener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener must not be null");
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Listener already set");
            this.listener = listener;
        }

        private void internalClose() {
            this.stream.close(Status.UNKNOWN, new Metadata());
        }

        @Override
        public void messagesAvailable(final StreamListener.MessageProducer producer) {
            PerfMark.startTask((String)"ServerStreamListener.messagesAvailable", (Tag)this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class MessagesAvailable
                extends ContextRunnable {
                    MessagesAvailable() {
                        super((Context)JumpToApplicationThreadServerStreamListener.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask((String)"ServerCallListener(app).messagesAvailable", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                        PerfMark.linkIn((Link)link);
                        try {
                            JumpToApplicationThreadServerStreamListener.this.getListener().messagesAvailable(producer);
                        }
                        catch (RuntimeException e) {
                            JumpToApplicationThreadServerStreamListener.this.internalClose();
                            throw e;
                        }
                        catch (Error e) {
                            JumpToApplicationThreadServerStreamListener.this.internalClose();
                            throw e;
                        }
                        finally {
                            PerfMark.stopTask((String)"ServerCallListener(app).messagesAvailable", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                        }
                    }
                }
                this.callExecutor.execute(new MessagesAvailable());
            }
            finally {
                PerfMark.stopTask((String)"ServerStreamListener.messagesAvailable", (Tag)this.tag);
            }
        }

        @Override
        public void halfClosed() {
            PerfMark.startTask((String)"ServerStreamListener.halfClosed", (Tag)this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class HalfClosed
                extends ContextRunnable {
                    HalfClosed() {
                        super((Context)JumpToApplicationThreadServerStreamListener.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask((String)"ServerCallListener(app).halfClosed", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                        PerfMark.linkIn((Link)link);
                        try {
                            JumpToApplicationThreadServerStreamListener.this.getListener().halfClosed();
                        }
                        catch (RuntimeException e) {
                            JumpToApplicationThreadServerStreamListener.this.internalClose();
                            throw e;
                        }
                        catch (Error e) {
                            JumpToApplicationThreadServerStreamListener.this.internalClose();
                            throw e;
                        }
                        finally {
                            PerfMark.stopTask((String)"ServerCallListener(app).halfClosed", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                        }
                    }
                }
                this.callExecutor.execute(new HalfClosed());
            }
            finally {
                PerfMark.stopTask((String)"ServerStreamListener.halfClosed", (Tag)this.tag);
            }
        }

        @Override
        public void closed(Status status) {
            PerfMark.startTask((String)"ServerStreamListener.closed", (Tag)this.tag);
            try {
                this.closedInternal(status);
            }
            finally {
                PerfMark.stopTask((String)"ServerStreamListener.closed", (Tag)this.tag);
            }
        }

        private void closedInternal(final Status status) {
            if (!status.isOk()) {
                this.cancelExecutor.execute(new ContextCloser(this.context, status.getCause()));
            }
            final Link link = PerfMark.linkOut();
            final class Closed
            extends ContextRunnable {
                Closed() {
                    super((Context)JumpToApplicationThreadServerStreamListener.this.context);
                }

                @Override
                public void runInContext() {
                    PerfMark.startTask((String)"ServerCallListener(app).closed", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                    PerfMark.linkIn((Link)link);
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().closed(status);
                    }
                    finally {
                        PerfMark.stopTask((String)"ServerCallListener(app).closed", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                    }
                }
            }
            this.callExecutor.execute(new Closed());
        }

        @Override
        public void onReady() {
            PerfMark.startTask((String)"ServerStreamListener.onReady", (Tag)this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class OnReady
                extends ContextRunnable {
                    OnReady() {
                        super((Context)JumpToApplicationThreadServerStreamListener.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask((String)"ServerCallListener(app).onReady", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                        PerfMark.linkIn((Link)link);
                        try {
                            JumpToApplicationThreadServerStreamListener.this.getListener().onReady();
                        }
                        catch (RuntimeException e) {
                            JumpToApplicationThreadServerStreamListener.this.internalClose();
                            throw e;
                        }
                        catch (Error e) {
                            JumpToApplicationThreadServerStreamListener.this.internalClose();
                            throw e;
                        }
                        finally {
                            PerfMark.stopTask((String)"ServerCallListener(app).onReady", (Tag)JumpToApplicationThreadServerStreamListener.this.tag);
                        }
                    }
                }
                this.callExecutor.execute(new OnReady());
            }
            finally {
                PerfMark.stopTask((String)"ServerStreamListener.onReady", (Tag)this.tag);
            }
        }
    }

    private static final class NoopListener
    implements ServerStreamListener {
        private NoopListener() {
        }

        @Override
        public void messagesAvailable(StreamListener.MessageProducer producer) {
            InputStream message;
            while ((message = producer.next()) != null) {
                try {
                    message.close();
                }
                catch (IOException e) {
                    while ((message = producer.next()) != null) {
                        try {
                            message.close();
                        }
                        catch (IOException ioException) {
                            log.log(Level.WARNING, "Exception closing stream", ioException);
                        }
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void halfClosed() {
        }

        @Override
        public void closed(Status status) {
        }

        @Override
        public void onReady() {
        }
    }

    private final class ServerTransportListenerImpl
    implements ServerTransportListener {
        private final ServerTransport transport;
        private Future<?> handshakeTimeoutFuture;
        private Attributes attributes;

        ServerTransportListenerImpl(ServerTransport transport) {
            this.transport = transport;
        }

        public void init() {
            class TransportShutdownNow
            implements Runnable {
                TransportShutdownNow() {
                }

                @Override
                public void run() {
                    ServerTransportListenerImpl.this.transport.shutdownNow(Status.CANCELLED.withDescription("Handshake timeout exceeded"));
                }
            }
            this.handshakeTimeoutFuture = ServerImpl.this.handshakeTimeoutMillis != Long.MAX_VALUE ? this.transport.getScheduledExecutorService().schedule(new TransportShutdownNow(), ServerImpl.this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS) : new FutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                }
            }, null);
            ServerImpl.this.channelz.addServerSocket((InternalInstrumented)ServerImpl.this, (InternalInstrumented)this.transport);
        }

        @Override
        public Attributes transportReady(Attributes attributes) {
            this.handshakeTimeoutFuture.cancel(false);
            this.handshakeTimeoutFuture = null;
            for (ServerTransportFilter filter : ServerImpl.this.transportFilters) {
                attributes = (Attributes)Preconditions.checkNotNull((Object)filter.transportReady(attributes), (String)"Filter %s returned null", (Object)filter);
            }
            this.attributes = attributes;
            return attributes;
        }

        @Override
        public void transportTerminated() {
            if (this.handshakeTimeoutFuture != null) {
                this.handshakeTimeoutFuture.cancel(false);
                this.handshakeTimeoutFuture = null;
            }
            for (ServerTransportFilter filter : ServerImpl.this.transportFilters) {
                filter.transportTerminated(this.attributes);
            }
            ServerImpl.this.transportClosed(this.transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void streamCreated(ServerStream stream, String methodName, Metadata headers) {
            Tag tag = PerfMark.createTag((String)methodName, (long)stream.streamId());
            PerfMark.startTask((String)"ServerTransportListener.streamCreated", (Tag)tag);
            try {
                this.streamCreatedInternal(stream, methodName, headers, tag);
            }
            finally {
                PerfMark.stopTask((String)"ServerTransportListener.streamCreated", (Tag)tag);
            }
        }

        private void streamCreatedInternal(final ServerStream stream, final String methodName, final Metadata headers, final Tag tag) {
            if (headers.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
                String encoding = (String)headers.get(GrpcUtil.MESSAGE_ENCODING_KEY);
                Decompressor decompressor = ServerImpl.this.decompressorRegistry.lookupDecompressor(encoding);
                if (decompressor == null) {
                    stream.close(Status.UNIMPLEMENTED.withDescription(String.format("Can't find decompressor for %s", encoding)), new Metadata());
                    return;
                }
                stream.setDecompressor(decompressor);
            }
            final StatsTraceContext statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)stream.statsTraceContext(), (Object)"statsTraceCtx not present from stream");
            final Context.CancellableContext context = this.createContext(stream, headers, statsTraceCtx);
            Executor wrappedExecutor = ServerImpl.this.executor == MoreExecutors.directExecutor() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(ServerImpl.this.executor);
            final Link link = PerfMark.linkOut();
            final JumpToApplicationThreadServerStreamListener jumpListener = new JumpToApplicationThreadServerStreamListener(wrappedExecutor, ServerImpl.this.executor, stream, context, tag);
            stream.setListener(jumpListener);
            final class StreamCreated
            extends ContextRunnable {
                StreamCreated() {
                    super((Context)cancellableContext);
                }

                @Override
                public void runInContext() {
                    PerfMark.startTask((String)"ServerTransportListener$StreamCreated.startCall", (Tag)tag);
                    PerfMark.linkIn((Link)link);
                    try {
                        this.runInternal();
                    }
                    finally {
                        PerfMark.stopTask((String)"ServerTransportListener$StreamCreated.startCall", (Tag)tag);
                    }
                }

                private void runInternal() {
                    ServerStreamListener listener = NOOP_LISTENER;
                    try {
                        ServerMethodDefinition method = ServerImpl.this.registry.lookupMethod(methodName);
                        if (method == null) {
                            method = ServerImpl.this.fallbackRegistry.lookupMethod(methodName, stream.getAuthority());
                        }
                        if (method == null) {
                            Status status = Status.UNIMPLEMENTED.withDescription("Method not found: " + methodName);
                            stream.close(status, new Metadata());
                            context.cancel(null);
                            return;
                        }
                        listener = ServerTransportListenerImpl.this.startCall(stream, methodName, method, headers, context, statsTraceCtx, tag);
                    }
                    catch (RuntimeException e) {
                        stream.close(Status.fromThrowable((Throwable)e), new Metadata());
                        context.cancel(null);
                        throw e;
                    }
                    catch (Error e) {
                        stream.close(Status.fromThrowable((Throwable)e), new Metadata());
                        context.cancel(null);
                        throw e;
                    }
                    finally {
                        jumpListener.setListener(listener);
                    }
                }
            }
            wrappedExecutor.execute(new StreamCreated());
        }

        private Context.CancellableContext createContext(final ServerStream stream, Metadata headers, StatsTraceContext statsTraceCtx) {
            Long timeoutNanos = (Long)headers.get(GrpcUtil.TIMEOUT_KEY);
            Context baseContext = statsTraceCtx.serverFilterContext(ServerImpl.this.rootContext);
            if (timeoutNanos == null) {
                return baseContext.withCancellation();
            }
            Context.CancellableContext context = baseContext.withDeadline(Deadline.after((long)timeoutNanos, (TimeUnit)TimeUnit.NANOSECONDS, (Deadline.Ticker)ServerImpl.this.ticker), this.transport.getScheduledExecutorService());
            final class ServerStreamCancellationListener
            implements Context.CancellationListener {
                ServerStreamCancellationListener() {
                }

                public void cancelled(Context context) {
                    Status status = Contexts.statusFromCancelled((Context)context);
                    if (Status.DEADLINE_EXCEEDED.getCode().equals((Object)status.getCode())) {
                        stream.cancel(status);
                    }
                }
            }
            context.addListener((Context.CancellationListener)new ServerStreamCancellationListener(), MoreExecutors.directExecutor());
            return context;
        }

        private <ReqT, RespT> ServerStreamListener startCall(ServerStream stream, String fullMethodName, ServerMethodDefinition<ReqT, RespT> methodDef, Metadata headers, Context.CancellableContext context, StatsTraceContext statsTraceCtx, Tag tag) {
            statsTraceCtx.serverCallStarted(new ServerCallInfoImpl(methodDef.getMethodDescriptor(), stream.getAttributes(), stream.getAuthority()));
            ServerCallHandler handler = methodDef.getServerCallHandler();
            for (ServerInterceptor interceptor : ServerImpl.this.interceptors) {
                handler = InternalServerInterceptors.interceptCallHandler((ServerInterceptor)interceptor, (ServerCallHandler)handler);
            }
            ServerMethodDefinition interceptedDef = methodDef.withServerCallHandler(handler);
            ServerMethodDefinition wMethodDef = ServerImpl.this.binlog == null ? interceptedDef : ServerImpl.this.binlog.wrapMethodDefinition(interceptedDef);
            return this.startWrappedCall(fullMethodName, wMethodDef, stream, headers, context, tag);
        }

        private <WReqT, WRespT> ServerStreamListener startWrappedCall(String fullMethodName, ServerMethodDefinition<WReqT, WRespT> methodDef, ServerStream stream, Metadata headers, Context.CancellableContext context, Tag tag) {
            ServerCallImpl call = new ServerCallImpl(stream, methodDef.getMethodDescriptor(), headers, context, ServerImpl.this.decompressorRegistry, ServerImpl.this.compressorRegistry, ServerImpl.this.serverCallTracer, tag);
            ServerCall.Listener listener = methodDef.getServerCallHandler().startCall(call, headers);
            if (listener == null) {
                throw new NullPointerException("startCall() returned a null listener for method " + fullMethodName);
            }
            return call.newServerStreamListener(listener);
        }
    }

    private final class ServerListenerImpl
    implements ServerListener {
        private ServerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerTransportListener transportCreated(ServerTransport transport) {
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transports.add(transport);
            }
            ServerTransportListenerImpl stli = new ServerTransportListenerImpl(transport);
            stli.init();
            return stli;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serverShutdown() {
            Status shutdownNowStatusCopy;
            ArrayList copiedTransports;
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.activeTransportServers--;
                if (ServerImpl.this.activeTransportServers != 0) {
                    return;
                }
                copiedTransports = new ArrayList(ServerImpl.this.transports);
                shutdownNowStatusCopy = ServerImpl.this.shutdownNowStatus;
                ServerImpl.this.serverShutdownCallbackInvoked = true;
            }
            for (ServerTransport transport : copiedTransports) {
                if (shutdownNowStatusCopy == null) {
                    transport.shutdown();
                    continue;
                }
                transport.shutdownNow(shutdownNowStatusCopy);
            }
            object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transportServersTerminated = true;
                ServerImpl.this.checkForTermination();
            }
        }
    }
}

