/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.update;

import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.NodeManager;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.tree.Tree;
import org.tron.p2p.dns.update.AliClient;
import org.tron.p2p.dns.update.AwsClient;
import org.tron.p2p.dns.update.DnsType;
import org.tron.p2p.dns.update.Publish;
import org.tron.p2p.dns.update.PublishConfig;

public class PublishService {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static final long publishDelay = 3600L;
    private ScheduledExecutorService publisher = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("publishService").build());
    private Publish publish;

    public void init() {
        PublishConfig publishConfig;
        boolean supportV4 = Parameter.p2pConfig.getIp() != null;
        if (this.checkConfig(supportV4, publishConfig = Parameter.p2pConfig.getPublishConfig())) {
            try {
                this.publish = this.getPublish(publishConfig);
                this.publish.testConnect();
            }
            catch (Exception e) {
                log.error("Init PublishService failed", (Throwable)e);
                return;
            }
            if (publishConfig.getStaticNodes() != null && !publishConfig.getStaticNodes().isEmpty()) {
                this.startPublish();
            } else {
                this.publisher.scheduleWithFixedDelay(this::startPublish, 300L, 3600L, TimeUnit.SECONDS);
            }
        }
    }

    private Publish getPublish(PublishConfig config) throws Exception {
        Publish publish = config.getDnsType() == DnsType.AliYun ? new AliClient(config.getAliDnsEndpoint(), config.getAccessKeyId(), config.getAccessKeySecret(), config.getChangeThreshold()) : new AwsClient(config.getAccessKeyId(), config.getAccessKeySecret(), config.getAwsHostZoneId(), config.getAwsRegion(), config.getChangeThreshold());
        return publish;
    }

    private void startPublish() {
        PublishConfig config = Parameter.p2pConfig.getPublishConfig();
        try {
            Tree tree = new Tree();
            List<String> nodes = this.getNodes(config);
            tree.makeTree(1, nodes, config.getKnownTreeUrls(), config.getDnsPrivate());
            log.info("Try to publish node count:{}", (Object)tree.getDnsNodes().size());
            this.publish.deploy(config.getDnsDomain(), tree);
        }
        catch (Exception e) {
            log.error("Failed to publish dns", (Throwable)e);
        }
    }

    private List<String> getNodes(PublishConfig config) throws UnknownHostException {
        HashSet<Node> nodes = new HashSet<Node>();
        if (config.getStaticNodes() != null && !config.getStaticNodes().isEmpty()) {
            for (InetSocketAddress staticAddress : config.getStaticNodes()) {
                if (staticAddress.getAddress() instanceof Inet4Address) {
                    nodes.add(new Node(null, staticAddress.getAddress().getHostAddress(), null, staticAddress.getPort()));
                    continue;
                }
                nodes.add(new Node(null, null, staticAddress.getAddress().getHostAddress(), staticAddress.getPort()));
            }
        } else {
            nodes.addAll(NodeManager.getConnectableNodes());
            nodes.add(NodeManager.getHomeNode());
        }
        ArrayList<DnsNode> dnsNodes = new ArrayList<DnsNode>();
        for (Node node : nodes) {
            DnsNode dnsNode = new DnsNode(node.getId(), node.getHostV4(), node.getHostV6(), node.getPort());
            dnsNodes.add(dnsNode);
        }
        return Tree.merge(dnsNodes, config.getMaxMergeSize());
    }

    private boolean checkConfig(boolean supportV4, PublishConfig config) {
        if (!config.isDnsPublishEnable()) {
            log.info("Dns publish service is disable");
            return false;
        }
        if (!supportV4) {
            log.error("Must have IP v4 connection to publish dns service");
            return false;
        }
        if (config.getDnsType() == null) {
            log.error("The dns server type must be specified when enabling the dns publishing service");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)config.getDnsDomain())) {
            log.error("The dns domain must be specified when enabling the dns publishing service");
            return false;
        }
        if (config.getDnsType() == DnsType.AliYun && (StringUtils.isEmpty((CharSequence)config.getAccessKeyId()) || StringUtils.isEmpty((CharSequence)config.getAccessKeySecret()) || StringUtils.isEmpty((CharSequence)config.getAliDnsEndpoint()))) {
            log.error("The configuration items related to the Aliyun dns server cannot be empty");
            return false;
        }
        if (config.getDnsType() == DnsType.AwsRoute53 && (StringUtils.isEmpty((CharSequence)config.getAccessKeyId()) || StringUtils.isEmpty((CharSequence)config.getAccessKeySecret()) || config.getAwsRegion() == null)) {
            log.error("The configuration items related to the AwsRoute53 dns server cannot be empty");
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.publisher.isShutdown()) {
            this.publisher.shutdown();
        }
    }
}

