/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.protocol.kad;

import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.discover.DiscoverService;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.message.kad.FindNodeMessage;
import org.tron.p2p.discover.message.kad.KadMessage;
import org.tron.p2p.discover.message.kad.NeighborsMessage;
import org.tron.p2p.discover.message.kad.PingMessage;
import org.tron.p2p.discover.message.kad.PongMessage;
import org.tron.p2p.discover.protocol.kad.DiscoverTask;
import org.tron.p2p.discover.protocol.kad.NodeHandler;
import org.tron.p2p.discover.protocol.kad.table.NodeTable;
import org.tron.p2p.discover.socket.UdpEvent;

public class KadService
implements DiscoverService {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static final int MAX_NODES = 2000;
    private static final int NODES_TRIM_THRESHOLD = 3000;
    private static long pingTimeout = 15000L;
    private final List<Node> bootNodes = new ArrayList<Node>();
    private volatile boolean inited = false;
    private final Map<InetSocketAddress, NodeHandler> nodeHandlerMap = new ConcurrentHashMap<InetSocketAddress, NodeHandler>();
    private Consumer<UdpEvent> messageSender;
    private NodeTable table;
    private Node homeNode;
    private ScheduledExecutorService pongTimer;
    private DiscoverTask discoverTask;

    @Override
    public void init() {
        for (InetSocketAddress address : Parameter.p2pConfig.getSeedNodes()) {
            this.bootNodes.add(new Node(address));
        }
        for (InetSocketAddress address : Parameter.p2pConfig.getActiveNodes()) {
            this.bootNodes.add(new Node(address));
        }
        this.pongTimer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("pongTimer").build());
        this.homeNode = new Node(Parameter.p2pConfig.getNodeID(), Parameter.p2pConfig.getIp(), Parameter.p2pConfig.getIpv6(), Parameter.p2pConfig.getPort());
        this.table = new NodeTable(this.homeNode);
        if (Parameter.p2pConfig.isDiscoverEnable()) {
            this.discoverTask = new DiscoverTask(this);
            this.discoverTask.init();
        }
    }

    @Override
    public void close() {
        try {
            if (this.pongTimer != null) {
                this.pongTimer.shutdownNow();
            }
            if (this.discoverTask != null) {
                this.discoverTask.close();
            }
        }
        catch (Exception e) {
            log.error("Close nodeManagerTasksTimer or pongTimer failed", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<Node> getConnectableNodes() {
        return this.getAllNodes().stream().filter(node -> node.isConnectible(Parameter.p2pConfig.getNetworkId())).filter(node -> node.getPreferInetSocketAddress() != null).collect(Collectors.toList());
    }

    @Override
    public List<Node> getTableNodes() {
        return this.table.getTableNodes();
    }

    @Override
    public List<Node> getAllNodes() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (NodeHandler nodeHandler : this.nodeHandlerMap.values()) {
            nodeList.add(nodeHandler.getNode());
        }
        return nodeList;
    }

    @Override
    public void setMessageSender(Consumer<UdpEvent> messageSender) {
        this.messageSender = messageSender;
    }

    @Override
    public void channelActivated() {
        if (!this.inited) {
            this.inited = true;
            for (Node node : this.bootNodes) {
                this.getNodeHandler(node);
            }
        }
    }

    @Override
    public void handleEvent(UdpEvent udpEvent) {
        KadMessage m = (KadMessage)udpEvent.getMessage();
        InetSocketAddress sender = udpEvent.getAddress();
        Node n = sender.getAddress() instanceof Inet4Address ? new Node(m.getFrom().getId(), sender.getHostString(), m.getFrom().getHostV6(), sender.getPort(), m.getFrom().getPort()) : new Node(m.getFrom().getId(), m.getFrom().getHostV4(), sender.getHostString(), sender.getPort(), m.getFrom().getPort());
        NodeHandler nodeHandler = this.getNodeHandler(n);
        nodeHandler.getNode().setId(n.getId());
        nodeHandler.getNode().touch();
        switch (m.getType()) {
            case KAD_PING: {
                nodeHandler.handlePing((PingMessage)m);
                break;
            }
            case KAD_PONG: {
                nodeHandler.handlePong((PongMessage)m);
                break;
            }
            case KAD_FIND_NODE: {
                nodeHandler.handleFindNode((FindNodeMessage)m);
                break;
            }
            case KAD_NEIGHBORS: {
                nodeHandler.handleNeighbours((NeighborsMessage)m, sender);
                break;
            }
        }
    }

    public NodeHandler getNodeHandler(Node n) {
        NodeHandler ret = null;
        InetSocketAddress inet4 = n.getInetSocketAddressV4();
        InetSocketAddress inet6 = n.getInetSocketAddressV6();
        if (inet4 != null) {
            ret = this.nodeHandlerMap.get(inet4);
        }
        if (ret == null && inet6 != null) {
            ret = this.nodeHandlerMap.get(inet6);
        }
        if (ret == null) {
            this.trimTable();
            ret = new NodeHandler(n, this);
            if (n.getPreferInetSocketAddress() != null) {
                this.nodeHandlerMap.put(n.getPreferInetSocketAddress(), ret);
            }
        } else {
            ret.getNode().updateHostV4(n.getHostV4());
            ret.getNode().updateHostV6(n.getHostV6());
        }
        return ret;
    }

    public NodeTable getTable() {
        return this.table;
    }

    @Override
    public Node getPublicHomeNode() {
        return this.homeNode;
    }

    public void sendOutbound(UdpEvent udpEvent) {
        if (Parameter.p2pConfig.isDiscoverEnable() && this.messageSender != null) {
            this.messageSender.accept(udpEvent);
        }
    }

    public ScheduledExecutorService getPongTimer() {
        return this.pongTimer;
    }

    private void trimTable() {
        if (this.nodeHandlerMap.size() > 3000) {
            this.nodeHandlerMap.values().forEach(handler -> {
                if (!handler.getNode().isConnectible(Parameter.p2pConfig.getNetworkId())) {
                    this.nodeHandlerMap.values().remove(handler);
                }
            });
        }
        if (this.nodeHandlerMap.size() > 3000) {
            ArrayList<NodeHandler> sorted = new ArrayList<NodeHandler>(this.nodeHandlerMap.values());
            sorted.sort(Comparator.comparingLong(o -> o.getNode().getUpdateTime()));
            for (NodeHandler handler2 : sorted) {
                this.nodeHandlerMap.values().remove(handler2);
                if (this.nodeHandlerMap.size() > 2000) continue;
                break;
            }
        }
    }

    public static long getPingTimeout() {
        return pingTimeout;
    }

    public static void setPingTimeout(long pingTimeout) {
        KadService.pingTimeout = pingTimeout;
    }
}

