/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.protocol.kad;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.protocol.kad.KadService;
import org.tron.p2p.utils.NetUtil;

public class DiscoverTask {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private ScheduledExecutorService discoverer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("discoverTask").build());
    private KadService kadService;
    private int loopNum = 0;
    private byte[] nodeId;

    public DiscoverTask(KadService kadService) {
        this.kadService = kadService;
    }

    public void init() {
        this.discoverer.scheduleWithFixedDelay(() -> {
            try {
                ++this.loopNum;
                if (this.loopNum % 5 == 0) {
                    this.loopNum = 0;
                    this.nodeId = this.kadService.getPublicHomeNode().getId();
                } else {
                    this.nodeId = NetUtil.getNodeId();
                }
                this.discover(this.nodeId, 0, new ArrayList<Node>());
            }
            catch (Exception e) {
                log.error("DiscoverTask fails to be executed", (Throwable)e);
            }
        }, 1L, 7200L, TimeUnit.MILLISECONDS);
        log.debug("DiscoverTask started");
    }

    private void discover(byte[] nodeId, int round, List<Node> prevTriedNodes) {
        List<Node> closest = this.kadService.getTable().getClosestNodes(nodeId);
        ArrayList<Node> tried = new ArrayList<Node>();
        for (Node n : closest) {
            if (!tried.contains(n) && !prevTriedNodes.contains(n)) {
                try {
                    this.kadService.getNodeHandler(n).sendFindNode(nodeId);
                    tried.add(n);
                }
                catch (Exception e) {
                    log.error("Unexpected Exception occurred while sending FindNodeMessage", (Throwable)e);
                }
            }
            if (tried.size() != 3) continue;
            break;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            log.warn("Discover task interrupted");
            Thread.currentThread().interrupt();
        }
        if (tried.isEmpty()) {
            return;
        }
        if (++round == 8) {
            return;
        }
        tried.addAll(prevTriedNodes);
        this.discover(nodeId, round, tried);
    }

    public void close() {
        this.discoverer.shutdownNow();
    }
}

