/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.socket;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.ChannelManager;

public class P2pChannelInitializer
extends ChannelInitializer<NioSocketChannel> {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final String remoteId;
    private boolean peerDiscoveryMode = false;
    private boolean trigger = true;

    public P2pChannelInitializer(String remoteId, boolean peerDiscoveryMode, boolean trigger) {
        this.remoteId = remoteId;
        this.peerDiscoveryMode = peerDiscoveryMode;
        this.trigger = trigger;
    }

    public void initChannel(NioSocketChannel ch) {
        try {
            Channel channel = new Channel();
            channel.init(ch.pipeline(), this.remoteId, this.peerDiscoveryMode);
            ch.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(262144));
            ch.config().setOption(ChannelOption.SO_RCVBUF, (Object)262144);
            ch.config().setOption(ChannelOption.SO_BACKLOG, (Object)1024);
            ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                channel.setDisconnect(true);
                if (channel.isDiscoveryMode()) {
                    ChannelManager.getNodeDetectService().notifyDisconnect(channel);
                } else {
                    try {
                        log.info("Close channel:{}", (Object)channel.getInetSocketAddress());
                        ChannelManager.notifyDisconnect(channel);
                    }
                    finally {
                        if (channel.getInetSocketAddress() != null && channel.isActive() && this.trigger) {
                            ChannelManager.triggerConnect(channel.getInetSocketAddress());
                        }
                    }
                }
            }));
        }
        catch (Exception e) {
            log.error("Unexpected initChannel error", (Throwable)e);
        }
    }
}

