/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.business.handshake;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.ChannelManager;
import org.tron.p2p.connection.business.MessageProcess;
import org.tron.p2p.connection.business.handshake.DisconnectCode;
import org.tron.p2p.connection.message.Message;
import org.tron.p2p.connection.message.base.P2pDisconnectMessage;
import org.tron.p2p.connection.message.handshake.HelloMessage;
import org.tron.p2p.protos.Connect;

public class HandshakeService
implements MessageProcess {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final int networkId = Parameter.p2pConfig.getNetworkId();

    public void startHandshake(Channel channel) {
        this.sendHelloMsg(channel, DisconnectCode.NORMAL, channel.getStartTime());
    }

    @Override
    public void processMessage(Channel channel, Message message) {
        HelloMessage msg = (HelloMessage)message;
        if (channel.isFinishHandshake()) {
            log.warn("Close channel {}, handshake is finished", (Object)channel.getInetSocketAddress());
            channel.send(new P2pDisconnectMessage(Connect.DisconnectReason.DUP_HANDSHAKE));
            channel.close();
            return;
        }
        channel.setHelloMessage(msg);
        DisconnectCode code = ChannelManager.processPeer(channel);
        if (code != DisconnectCode.NORMAL) {
            if (!channel.isActive()) {
                this.sendHelloMsg(channel, code, msg.getTimestamp());
            }
            ChannelManager.logDisconnectReason(channel, ChannelManager.getDisconnectReason(code));
            channel.close();
            return;
        }
        ChannelManager.updateNodeId(channel, msg.getFrom().getHexId());
        if (channel.isDisconnect()) {
            return;
        }
        if (channel.isActive()) {
            if (msg.getCode() != DisconnectCode.NORMAL.getValue().intValue() || msg.getNetworkId() != this.networkId && msg.getVersion() != this.networkId) {
                DisconnectCode disconnectCode = DisconnectCode.forNumber(msg.getCode());
                log.info("Handshake failed {}, code: {}, reason: {}, networkId: {}, version: {}", new Object[]{channel.getInetSocketAddress(), msg.getCode(), disconnectCode.name(), msg.getNetworkId(), msg.getVersion()});
                ChannelManager.logDisconnectReason(channel, ChannelManager.getDisconnectReason(disconnectCode));
                channel.close();
                return;
            }
        } else {
            if (msg.getNetworkId() != this.networkId) {
                log.info("Peer {} different network id, peer->{}, me->{}", new Object[]{channel.getInetSocketAddress(), msg.getNetworkId(), this.networkId});
                this.sendHelloMsg(channel, DisconnectCode.DIFFERENT_VERSION, msg.getTimestamp());
                ChannelManager.logDisconnectReason(channel, Connect.DisconnectReason.DIFFERENT_VERSION);
                channel.close();
                return;
            }
            this.sendHelloMsg(channel, DisconnectCode.NORMAL, msg.getTimestamp());
        }
        channel.setFinishHandshake(true);
        channel.updateAvgLatency(System.currentTimeMillis() - channel.getStartTime());
        Parameter.handlerList.forEach(h -> h.onConnect(channel));
    }

    private void sendHelloMsg(Channel channel, DisconnectCode code, long time) {
        HelloMessage helloMessage = new HelloMessage(code, time);
        channel.send(helloMessage);
    }
}

