/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.types;

import conflux.web3j.CfxUnit;
import conflux.web3j.types.Address;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class RawTransaction {
    private static AtomicReference<BigInteger> DefaultGasPrice = new AtomicReference<BigInteger>(CfxUnit.DEFAULT_GAS_PRICE);
    private static AtomicReference<BigInteger> DefaultChainId = new AtomicReference<BigInteger>(BigInteger.valueOf(1029L));
    private BigInteger nonce;
    private BigInteger gasPrice;
    private BigInteger gas;
    private Address to;
    private BigInteger value;
    private BigInteger storageLimit;
    private BigInteger epochHeight;
    private BigInteger chainId;
    private String data;

    public static BigInteger getDefaultGasPrice() {
        return DefaultGasPrice.get();
    }

    public static void setDefaultGasPrice(BigInteger defaultGasPrice) {
        DefaultGasPrice.set(defaultGasPrice);
    }

    public static BigInteger getDefaultChainId() {
        return DefaultChainId.get();
    }

    public static void setDefaultChainId(BigInteger defaultChainId) {
        DefaultChainId.set(defaultChainId);
    }

    public static RawTransaction create(BigInteger nonce, BigInteger gas, Address to, BigInteger value, BigInteger storageLimit, BigInteger epochHeight, String data) {
        RawTransaction tx = new RawTransaction();
        tx.nonce = nonce;
        tx.gasPrice = DefaultGasPrice.get();
        tx.gas = gas;
        tx.to = to;
        tx.value = value;
        tx.storageLimit = storageLimit;
        tx.epochHeight = epochHeight;
        tx.chainId = DefaultChainId.get();
        tx.data = data;
        return tx;
    }

    public static RawTransaction transfer(BigInteger nonce, Address to, BigInteger value, BigInteger epochHeight) {
        return RawTransaction.create(nonce, CfxUnit.DEFAULT_GAS_LIMIT, to, value, BigInteger.ZERO, epochHeight, null);
    }

    public static RawTransaction deploy(BigInteger nonce, BigInteger gas, BigInteger storageLimit, BigInteger epochHeight, String bytecodes) {
        return RawTransaction.create(nonce, gas, null, BigInteger.ZERO, storageLimit, epochHeight, bytecodes);
    }

    public static RawTransaction deploy(BigInteger nonce, BigInteger gas, BigInteger value, BigInteger storageLimit, BigInteger epochHeight, String bytecodes) {
        return RawTransaction.create(nonce, gas, null, value, storageLimit, epochHeight, bytecodes);
    }

    public static RawTransaction call(BigInteger nonce, BigInteger gas, Address to, BigInteger storageLimit, BigInteger epochHeight, String data) {
        return RawTransaction.create(nonce, gas, to, BigInteger.ZERO, storageLimit, epochHeight, data);
    }

    public String sign(ECKeyPair ecKeyPair) {
        RlpType rlpTx = this.toRlp();
        byte[] encoded = RlpEncoder.encode((RlpType)rlpTx);
        Sign.SignatureData signature = Sign.signMessage((byte[])encoded, (ECKeyPair)ecKeyPair);
        int v = signature.getV()[0] - 27;
        byte[] r = Bytes.trimLeadingZeroes((byte[])signature.getR());
        byte[] s = Bytes.trimLeadingZeroes((byte[])signature.getS());
        byte[] signedTx = RlpEncoder.encode((RlpType)new RlpList(new RlpType[]{rlpTx, RlpString.create((long)v), RlpString.create((byte[])r), RlpString.create((byte[])s)}));
        return Numeric.toHexString((byte[])signedTx);
    }

    public RlpType toRlp() {
        ArrayList<RlpString> values = new ArrayList<RlpString>();
        values.add(RlpString.create((BigInteger)this.nonce));
        values.add(RlpString.create((BigInteger)this.gasPrice));
        values.add(RlpString.create((BigInteger)this.gas));
        if (this.to != null) {
            values.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.to.getHexAddress())));
        } else {
            values.add(RlpString.create((String)""));
        }
        values.add(RlpString.create((BigInteger)this.value));
        values.add(RlpString.create((BigInteger)this.storageLimit));
        values.add(RlpString.create((BigInteger)this.epochHeight));
        values.add(RlpString.create((BigInteger)this.chainId));
        values.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)(this.data == null ? "" : this.data))));
        return new RlpList(values);
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(BigInteger gasPrice) {
        this.gasPrice = gasPrice;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public void setGas(BigInteger gas) {
        this.gas = gas;
    }

    public Address getTo() {
        return this.to;
    }

    public void setTo(Address to) {
        this.to = to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public BigInteger getStorageLimit() {
        return this.storageLimit;
    }

    public void setStorageLimit(BigInteger storageLimit) {
        this.storageLimit = storageLimit;
    }

    public BigInteger getEpochHeight() {
        return this.epochHeight;
    }

    public void setEpochHeight(BigInteger epochHeight) {
        this.epochHeight = epochHeight;
    }

    public BigInteger getChainId() {
        return this.chainId;
    }

    public void setChainId(BigInteger chainId) {
        this.chainId = chainId;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

