/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.types;

import conflux.web3j.types.AddressException;
import java.util.HashMap;
import java.util.Optional;
import org.web3j.utils.Numeric;

public enum AddressType {
    Null("null", "null address type required"),
    Builtin("builtin", "builtin address type required"),
    User("user", "user address type required"),
    Contract("contract", "contract address type required");

    private static final HashMap<String, Character> TYPE_MAP;
    private String value;
    private String typeMismatchException;
    private static final int HEX_LENGTH_WITH_PREFIX = 42;

    private AddressType(String value, String ae) {
        this.value = value;
        this.typeMismatchException = ae;
    }

    public String getValue() {
        return this.value;
    }

    public AddressException getTypeMismatchException() {
        return new AddressException(this.typeMismatchException);
    }

    public String normalize(String hexAddress) {
        return String.format("0x%s%s", TYPE_MAP.get(this.value), Numeric.cleanHexPrefix((String)hexAddress).substring(1));
    }

    public static Optional<AddressType> parse(char ch) {
        switch (ch) {
            case '0': {
                return Optional.of(Builtin);
            }
            case '1': {
                return Optional.of(User);
            }
            case '8': {
                return Optional.of(Contract);
            }
        }
        return Optional.empty();
    }

    public static void validateHexAddress(String hexValue) throws AddressException {
        AddressType.validateHexAddress(hexValue, null);
    }

    public static void validateHexAddress(String hexValue, AddressType expectedType) throws AddressException {
        if (!Numeric.containsHexPrefix((String)hexValue)) {
            throw new AddressException("HEX prefix 0x missed");
        }
        if (hexValue.length() != 42) {
            throw new AddressException("wrong length");
        }
        Optional<AddressType> type = AddressType.parse(hexValue.charAt(2));
        if (!type.isPresent()) {
            throw new AddressException("wrong type");
        }
        if (expectedType != null && !type.get().equals((Object)expectedType)) {
            throw expectedType.getTypeMismatchException();
        }
        for (int i = 2; i < 42; ++i) {
            char ch = hexValue.charAt(i);
            if (!(ch < '0' || ch > '9' && ch < 'A' || ch > 'Z' && ch < 'a') && ch <= 'z') continue;
            throw new AddressException("wrong HEX format");
        }
    }

    static {
        TYPE_MAP = new HashMap();
        TYPE_MAP.put("builtin", Character.valueOf('0'));
        TYPE_MAP.put("user", Character.valueOf('1'));
        TYPE_MAP.put("contract", Character.valueOf('8'));
    }
}

