/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.request;

import conflux.web3j.HasValue;
import conflux.web3j.request.DefaultEpoch;
import conflux.web3j.request.EpochByValue;
import java.math.BigInteger;
import org.web3j.utils.Numeric;

public interface Epoch
extends HasValue<String> {
    public static Epoch earliest() {
        return DefaultEpoch.EARLIEST;
    }

    public static Epoch latestState() {
        return DefaultEpoch.LATEST_STATE;
    }

    public static Epoch latestMined() {
        return DefaultEpoch.LATEST_MINED;
    }

    public static Epoch latestCheckpoint() {
        return DefaultEpoch.LATEST_CHECKPOINT;
    }

    public static Epoch latestConfirmed() {
        return DefaultEpoch.LATEST_CONFIRMED;
    }

    public static Epoch numberOf(long number) {
        String value = Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(number));
        return new EpochByValue(value);
    }

    public static Epoch numberOf(BigInteger number) {
        String value = Numeric.encodeQuantity((BigInteger)number);
        return new EpochByValue(value);
    }

    public static Epoch hashOf(String blockHash) {
        return new EpochByValue(blockHash);
    }
}

