/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.crypto;

import com.google.common.io.BaseEncoding;
import conflux.web3j.crypto.ConfluxBase32Exception;
import java.util.HashMap;

public class ConfluxBase32 {
    private static final String CONFLUX_CHARSET = "abcdefghjkmnprstuvwxyz0123456789";
    private static final String STANDARD_CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final char PADDING_CHAR = '=';
    private static final HashMap<Character, Integer> CONFLUX_CHAR_MAP;
    private static final HashMap<Character, Integer> STANDARD_CHAR_MAP;

    public static String encode(byte[] buffer) throws ConfluxBase32Exception {
        if (buffer == null) {
            throw new ConfluxBase32Exception("buffer is null or empty");
        }
        return ConfluxBase32.fromStandard(BaseEncoding.base32().encode(buffer));
    }

    public static byte[] decode(String base32Str) throws ConfluxBase32Exception {
        if (!ConfluxBase32.isValid(base32Str)) {
            throw new ConfluxBase32Exception("include invalid char");
        }
        return BaseEncoding.base32().decode((CharSequence)ConfluxBase32.toStandard(base32Str));
    }

    public static byte[] decodeWords(String base32Words) throws ConfluxBase32Exception {
        if (!ConfluxBase32.isValid(base32Words)) {
            throw new ConfluxBase32Exception("include invalid char");
        }
        byte[] result = new byte[base32Words.length()];
        for (int i = 0; i < base32Words.length(); ++i) {
            int num = CONFLUX_CHAR_MAP.get(Character.valueOf(base32Words.charAt(i)));
            result[i] = (byte)num;
        }
        return result;
    }

    public static String encodeWords(byte[] words) throws ConfluxBase32Exception {
        if (words == null) {
            throw new ConfluxBase32Exception("buffer is null or empty");
        }
        StringBuilder result = new StringBuilder(words.length);
        for (byte word : words) {
            if (word < 0 || word > 31) {
                throw new ConfluxBase32Exception("word should in range [0-31]");
            }
            result.append(CONFLUX_CHARSET.charAt(word));
        }
        return result.toString();
    }

    public static boolean isValid(String base32Str) {
        if (base32Str == null) {
            return false;
        }
        for (int i = 0; i < base32Str.length(); ++i) {
            if (CONFLUX_CHAR_MAP.containsKey(Character.valueOf(base32Str.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static String toStandard(String base32Str) {
        StringBuilder result = new StringBuilder(base32Str.length());
        for (int i = 0; i < base32Str.length(); ++i) {
            char c = base32Str.charAt(i);
            int index = CONFLUX_CHAR_MAP.get(Character.valueOf(c));
            result.append(STANDARD_CHARSET.charAt(index));
        }
        return result.toString();
    }

    private static String fromStandard(String standardBase32Str) {
        char c;
        StringBuilder result = new StringBuilder(standardBase32Str.length());
        for (int i = 0; i < standardBase32Str.length() && (c = standardBase32Str.charAt(i)) != '='; ++i) {
            int index = STANDARD_CHAR_MAP.get(Character.valueOf(c));
            result.append(CONFLUX_CHARSET.charAt(index));
        }
        return result.toString();
    }

    static {
        int i;
        CONFLUX_CHAR_MAP = new HashMap();
        for (i = 0; i < CONFLUX_CHARSET.length(); ++i) {
            CONFLUX_CHAR_MAP.put(Character.valueOf(CONFLUX_CHARSET.charAt(i)), i);
        }
        STANDARD_CHAR_MAP = new HashMap();
        for (i = 0; i < STANDARD_CHARSET.length(); ++i) {
            STANDARD_CHAR_MAP.put(Character.valueOf(STANDARD_CHARSET.charAt(i)), i);
        }
    }
}

