/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.contract.internals;

import conflux.web3j.Account;
import conflux.web3j.Cfx;
import conflux.web3j.RpcException;
import conflux.web3j.contract.ContractCall;
import conflux.web3j.types.CfxAddress;
import java.math.BigInteger;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;

public class Staking
extends ContractCall {
    private static final String contract = "0x0888000000000000000000000000000000000002";
    private Account account;
    private final CfxAddress contractAddress;

    public Staking(Account account) {
        super(account.getCfx(), new CfxAddress(contract, account.getCfx().getIntNetworkId()));
        this.contractAddress = new CfxAddress(contract, account.getCfx().getIntNetworkId());
        this.account = account;
    }

    public Staking(Cfx cfx) {
        super(cfx, new CfxAddress(contract, cfx.getIntNetworkId()));
        this.contractAddress = new CfxAddress(contract, cfx.getIntNetworkId());
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public BigInteger getStakingBalance(Address user) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "getStakingBalance", new Type[]{user});
    }

    public BigInteger getLockedStakingBalance(Address user, BigInteger blockNumber) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "getLockedStakingBalance", new Type[]{user, new Uint256(blockNumber)});
    }

    public BigInteger getVotePower(Address user, BigInteger blockNumber) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "getVotePower", new Type[]{user, new Uint256(blockNumber)});
    }

    public String deposit(Account.Option option, BigInteger amount) throws Exception {
        return this.account.call(option, this.contractAddress, "deposit", new Type[]{new Uint256(amount)});
    }

    public String voteLock(Account.Option option, BigInteger amount, BigInteger unlockBlockNumber) throws Exception {
        return this.account.call(option, this.contractAddress, "voteLock", new Type[]{new Uint256(amount), new Uint256(unlockBlockNumber)});
    }

    public String withdraw(Account.Option option, BigInteger amount) throws Exception {
        return this.account.call(option, this.contractAddress, "withdraw", new Type[]{new Uint256(amount)});
    }
}

