/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.contract.internals;

import conflux.web3j.Account;
import conflux.web3j.Cfx;
import conflux.web3j.RpcException;
import conflux.web3j.contract.ContractCall;
import conflux.web3j.types.CfxAddress;
import java.math.BigInteger;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;

public class SponsorWhitelistControl
extends ContractCall {
    private static final String contract = "0x0888000000000000000000000000000000000001";
    private Account account;
    private final CfxAddress contractAddress;

    public SponsorWhitelistControl(Account account) {
        super(account.getCfx(), new CfxAddress(contract, account.getCfx().getIntNetworkId()));
        this.contractAddress = new CfxAddress(contract, account.getCfx().getIntNetworkId());
        this.account = account;
    }

    public SponsorWhitelistControl(Cfx cfx) {
        super(cfx, new CfxAddress(contract, cfx.getIntNetworkId()));
        this.contractAddress = new CfxAddress(contract, cfx.getIntNetworkId());
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Address getSponsorForGas(Address contractAddr) throws RpcException {
        String hexAddress = (String)this.callAndGet(Address.class, "getSponsorForGas", new Type[]{contractAddr});
        return new Address(hexAddress);
    }

    public BigInteger getSponsoredBalanceForGas(Address contractAddr) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "getSponsoredBalanceForGas", new Type[]{contractAddr});
    }

    public BigInteger getSponsoredGasFeeUpperBound(Address contractAddr) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "getSponsoredGasFeeUpperBound", new Type[]{contractAddr});
    }

    public Address getSponsorForCollateral(Address contractAddr) throws RpcException {
        String hexAddress = (String)this.callAndGet(Address.class, "getSponsorForCollateral", new Type[]{contractAddr});
        return new Address(hexAddress);
    }

    public BigInteger getSponsoredBalanceForCollateral(Address contractAddr) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "getSponsoredBalanceForCollateral", new Type[]{contractAddr});
    }

    public boolean isWhitelisted(Address contractAddr, Address user) throws RpcException {
        return (Boolean)this.callAndGet(Bool.class, "isWhitelisted", new Type[]{contractAddr, contractAddr});
    }

    public boolean isAllWhitelisted(Address contractAddr) throws RpcException {
        return (Boolean)this.callAndGet(Bool.class, "isAllWhitelisted", new Type[]{contractAddr});
    }

    public String setSponsorForCollateral(Account.Option option, Address contractAddr) throws Exception {
        return this.account.call(option, this.contractAddress, "setSponsorForCollateral", new Type[]{contractAddr});
    }

    public String setSponsorForGas(Account.Option option, Address contractAddr, BigInteger upperBound) throws Exception {
        return this.account.call(option, this.contractAddress, "setSponsorForGas", new Type[]{contractAddr, new Uint256(upperBound)});
    }

    public String addPrivilegeByAdmin(Account.Option option, Address contractAddr, Address[] addresses) throws Exception {
        return this.account.call(option, this.contractAddress, "addPrivilegeByAdmin", new Type[]{contractAddr, new DynamicArray(Address.class, (Type[])addresses)});
    }

    public String removePrivilegeByAdmin(Account.Option option, Address contractAddr, Address[] addresses) throws Exception {
        return this.account.call(option, this.contractAddress, "removePrivilegeByAdmin", new Type[]{contractAddr, new DynamicArray(Address.class, (Type[])addresses)});
    }
}

