/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.contract.internals;

import conflux.web3j.Account;
import conflux.web3j.Cfx;
import conflux.web3j.RpcException;
import conflux.web3j.contract.ContractCall;
import conflux.web3j.types.CfxAddress;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Type;

public class AdminControl
extends ContractCall {
    private static final String contract = "0x0888000000000000000000000000000000000000";
    private Account account;
    private CfxAddress contractAddress;

    public AdminControl(Account account) {
        super(account.getCfx(), new CfxAddress(contract, account.getCfx().getIntNetworkId()));
        this.contractAddress = new CfxAddress(contract, account.getCfx().getIntNetworkId());
        this.account = account;
    }

    public AdminControl(Cfx cfx) {
        super(cfx, new CfxAddress(contract, cfx.getIntNetworkId()));
        this.contractAddress = new CfxAddress(contract, cfx.getIntNetworkId());
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Address getAdmin(Address contractAddr) throws RpcException {
        String hexAddress = (String)this.callAndGet(Address.class, "getAdmin", new Type[]{contractAddr});
        return new Address(hexAddress);
    }

    public String destroy(Account.Option option, Address contractAddr) throws Exception {
        Address admin = this.getAdmin(contractAddr);
        if (!admin.getValue().equalsIgnoreCase(this.account.getAddress().getHexAddress())) {
            throw new Exception("Administrator privilege required");
        }
        return this.account.call(option, this.contractAddress, "destroy", new Type[]{contractAddr});
    }

    public String setAdmin(Account.Option option, Address contractAddr, Address newAdmin) throws Exception {
        Address admin = this.getAdmin(contractAddr);
        if (!admin.getValue().equalsIgnoreCase(this.account.getAddress().getHexAddress())) {
            throw new Exception("Administrator privilege required");
        }
        return this.account.call(option, this.contractAddress, "setAdmin", new Type[]{contractAddr, newAdmin});
    }
}

