/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.contract.abi;

import java.util.Arrays;
import java.util.List;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.utils.Numeric;

public class DecodeUtil {
    public static <D, T extends Type<D>> D decode(String encodedResult, Class<T> returnType) {
        TypeReference returnTypeRef = TypeReference.create(returnType);
        List decoded = FunctionReturnDecoder.decode((String)encodedResult, Arrays.asList(returnTypeRef));
        if (decoded == null || decoded.isEmpty()) {
            return null;
        }
        return (D)((Type)decoded.get(0)).getValue();
    }

    public static <T extends Type<?>> List<T> decode(String encodedResult, TypeReference.StaticArrayTypeReference<StaticArray<T>> returnType) {
        List decoded = FunctionReturnDecoder.decode((String)encodedResult, Arrays.asList(returnType));
        if (decoded == null || decoded.isEmpty()) {
            return null;
        }
        return ((StaticArray)decoded.get(0)).getValue();
    }

    public static <T extends Type<?>> List<T> decode(String encodedResult, TypeReference<DynamicArray<T>> returnType) {
        List decoded = FunctionReturnDecoder.decode((String)encodedResult, Arrays.asList(returnType));
        if (decoded == null || decoded.isEmpty()) {
            return null;
        }
        return ((DynamicArray)decoded.get(0)).getValue();
    }

    public static String decodeErrorData(String data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        if ((data = data.replace("\"", "").replace("\\", "")).length() <= 10 || (data.length() - 10) % 64 != 0) {
            return new String(Numeric.hexStringToByteArray((String)data));
        }
        try {
            data = data.substring(10);
            return (String)DecodeUtil.decode(data, Utf8String.class);
        }
        catch (Exception e) {
            return new String(Numeric.hexStringToByteArray((String)data));
        }
    }
}

