/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j.contract;

import conflux.web3j.Account;
import conflux.web3j.Cfx;
import conflux.web3j.RpcException;
import conflux.web3j.contract.ContractCall;
import conflux.web3j.types.CfxAddress;
import java.math.BigInteger;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;

public class ERC20
extends ContractCall {
    private Account account;
    private CfxAddress contract;

    public ERC20(Cfx cfx, CfxAddress address) {
        super(cfx, address);
    }

    public ERC20(Cfx cfx, CfxAddress address, Account account) {
        super(cfx, address);
        this.account = account;
        this.contract = address;
    }

    public BigInteger totalSupply() throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "totalSupply", new Type[0]);
    }

    public BigInteger balanceOf(Address account) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "balanceOf", new Type[]{account});
    }

    public BigInteger allowance(Address owner, Address spender) throws RpcException {
        return (BigInteger)this.callAndGet(Uint256.class, "allowance", new Type[]{owner, spender});
    }

    public String transfer(Account.Option option, Address recipient, BigInteger amount) throws Exception {
        return this.account.call(option, this.contract, "transfer", new Type[]{recipient, new Uint256(amount)});
    }

    public String approve(Account.Option option, Address spender, BigInteger amount) throws Exception {
        return this.account.call(option, this.contract, "approve", new Type[]{spender, new Uint256(amount)});
    }

    public String transferFrom(Account.Option option, Address sender, Address recipient, BigInteger amount) throws Exception {
        return this.account.call(option, this.contract, "transferFrom", new Type[]{sender, recipient, new Uint256(amount)});
    }
}

