/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j;

import java.io.IOException;
import org.web3j.protocol.core.Response;

public class RpcException
extends RuntimeException {
    private static final long serialVersionUID = 4965906647640407824L;
    public static final Response.Error ERROR_IO_SEND = new Response.Error(-1, "failed to send RPC request (IO error)");
    public static final Response.Error ERROR_INTERRUPTED = new Response.Error(-2, "failed to send RPC request (interrupted)");
    private Response.Error error;

    public RpcException() {
    }

    public RpcException(Response.Error error) {
        super(RpcException.buildErrorMessage(error));
        this.error = error;
    }

    public RpcException(Response.Error error, Throwable cause) {
        super(RpcException.buildErrorMessage(error), cause);
        this.error = error;
    }

    private static String buildErrorMessage(Response.Error error) {
        return String.format("RPC error: code = %d, message = %s, data = %s", error.getCode(), error.getMessage(), error.getData());
    }

    private static RpcException predefined(Response.Error template, Throwable e) {
        Response.Error error = new Response.Error(template.getCode(), template.getMessage());
        error.setData(e.getMessage());
        return new RpcException(error, e);
    }

    public static RpcException sendFailure(IOException e) {
        return RpcException.predefined(ERROR_IO_SEND, e);
    }

    public static RpcException interrupted(InterruptedException e) {
        return RpcException.predefined(ERROR_INTERRUPTED, e);
    }

    public Response.Error getError() {
        return this.error;
    }
}

