/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j;

import conflux.web3j.CfxPubSub;
import conflux.web3j.Request;
import conflux.web3j.RpcException;
import conflux.web3j.Web3j;
import conflux.web3j.request.Call;
import conflux.web3j.request.Epoch;
import conflux.web3j.request.LogFilter;
import conflux.web3j.response.AccountInfo;
import conflux.web3j.response.AccountPendingInfo;
import conflux.web3j.response.AccountPendingTransactions;
import conflux.web3j.response.BigIntNullableResponse;
import conflux.web3j.response.BigIntResponse;
import conflux.web3j.response.Block;
import conflux.web3j.response.BlockRevertRateResponse;
import conflux.web3j.response.BlockSummary;
import conflux.web3j.response.DepositInfo;
import conflux.web3j.response.Log;
import conflux.web3j.response.Receipt;
import conflux.web3j.response.RewardInfo;
import conflux.web3j.response.SponsorInfo;
import conflux.web3j.response.Status;
import conflux.web3j.response.StorageRoot;
import conflux.web3j.response.StringNullableResponse;
import conflux.web3j.response.StringResponse;
import conflux.web3j.response.SupplyInfo;
import conflux.web3j.response.Transaction;
import conflux.web3j.response.UsedGasAndCollateral;
import conflux.web3j.response.VoteStakeInfo;
import conflux.web3j.types.Address;
import conflux.web3j.types.SendTransactionResult;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.http.HttpService;

public interface Cfx
extends Closeable,
CfxPubSub {
    public static Cfx create(String url) {
        return new Web3j((Web3jService)new HttpService(url));
    }

    public static Cfx create(String url, int retry) {
        return new Web3j((Web3jService)new HttpService(url), retry, 0L);
    }

    public static Cfx create(String url, int retry, long intervalMillis) {
        return new Web3j((Web3jService)new HttpService(url), retry, intervalMillis);
    }

    public static Cfx create(Web3jService service) {
        return new Web3j(service);
    }

    public static Cfx create(Web3jService service, int retry, long intervalMillis) {
        return new Web3j(service, retry, intervalMillis);
    }

    public BigInteger getNetworkId();

    public int getIntNetworkId();

    public BigInteger getChainId();

    public Request<BigInteger, BigIntResponse> getGasPrice();

    public Request<BigInteger, BigIntResponse> getEpochNumber(Epoch ... var1);

    public Request<BigInteger, BigIntResponse> getBalance(Address var1, Epoch ... var2);

    public Request<Optional<String>, StringNullableResponse> getAdmin(Address var1, Epoch ... var2);

    public Request<SponsorInfo, SponsorInfo.Response> getSponsorInfo(Address var1, Epoch ... var2);

    public Request<BigInteger, BigIntResponse> getStakingBalance(Address var1, Epoch ... var2);

    public Request<BigInteger, BigIntResponse> getCollateralForStorage(Address var1, Epoch ... var2);

    public Request<String, StringResponse> getCode(Address var1, Epoch ... var2);

    public Request<Optional<String>, StringNullableResponse> getStorageAt(Address var1, String var2, Epoch ... var3);

    public Request<Optional<StorageRoot>, StorageRoot.Response> getStorageRoot(Address var1, Epoch ... var2);

    public Request<Optional<BlockSummary>, BlockSummary.Response> getBlockSummaryByHash(String var1);

    public Request<Optional<Block>, Block.Response> getBlockByHash(String var1);

    public Request<Optional<BlockSummary>, BlockSummary.Response> getBlockSummaryByEpoch(Epoch var1);

    public Request<Optional<Block>, Block.Response> getBlockByEpoch(Epoch var1);

    public Request<String, StringResponse> getBestBlockHash();

    public Request<BigInteger, BigIntResponse> getNonce(Address var1, Epoch ... var2);

    public Request<String, StringResponse> sendRawTransaction(String var1);

    public Request<String, StringResponse> call(Call var1, Epoch ... var2);

    public Request<List<Log>, Log.Response> getLogs(LogFilter var1);

    public Request<Optional<Transaction>, Transaction.Response> getTransactionByHash(String var1);

    public Request<UsedGasAndCollateral, UsedGasAndCollateral.Response> estimateGasAndCollateral(Call var1, Epoch ... var2);

    public Request<List<String>, Block.ListResponse> getBlocksByEpoch(Epoch var1);

    public Request<List<String>, Block.ListResponse> getSkippedBlocksByEpoch(Epoch var1);

    public Request<Optional<Receipt>, Receipt.Response> getTransactionReceipt(String var1);

    public Request<AccountInfo, AccountInfo.Response> getAccount(Address var1, Epoch ... var2);

    public Request<BigInteger, BigIntResponse> getInterestRate(Epoch ... var1);

    public Request<BigInteger, BigIntResponse> getAccumulateInterestRate(Epoch ... var1);

    public Request<Optional<BigInteger>, BigIntNullableResponse> getConfirmationRisk(String var1);

    public Request<BigDecimal, BlockRevertRateResponse> getBlockRevertRate(String var1);

    public Request<Status, Status.Response> getStatus();

    public Request<List<RewardInfo>, RewardInfo.Response> getReward(Epoch var1);

    public Request<String, StringResponse> getClientVersion();

    public Request<List<DepositInfo>, DepositInfo.ListResponse> getDepositList(Address var1, Epoch ... var2);

    public Request<List<VoteStakeInfo>, VoteStakeInfo.ListResponse> getVoteList(Address var1, Epoch ... var2);

    public Request<SupplyInfo, SupplyInfo.Response> getSupplyInfo(Epoch ... var1);

    public Request<Optional<AccountPendingInfo>, AccountPendingInfo.Response> getAccountPendingInfo(Address var1);

    public Request<AccountPendingTransactions, AccountPendingTransactions.Response> getAccountPendingTransactions(Address var1);

    public <T, R extends Response<?>> Request<T, R> getCustomizedRequest(Class<R> var1, String var2, Object ... var3);

    default public Receipt waitForReceipt(String txHash) throws InterruptedException {
        return this.waitForReceipt(txHash, 1000L);
    }

    default public Receipt waitForReceipt(String txHash, long intervalMillis) throws InterruptedException {
        Optional<Object> receipt = Optional.empty();
        while (!receipt.isPresent()) {
            Thread.sleep(intervalMillis);
            receipt = this.getTransactionReceipt(txHash).sendAndGet();
        }
        return (Receipt)receipt.get();
    }

    default public void waitForNonce(Address address, BigInteger nonceUntil) throws InterruptedException {
        this.waitForNonce(address, nonceUntil, 1000L);
    }

    default public void waitForNonce(Address address, BigInteger nonceUntil, long intervalMillis) throws InterruptedException {
        while (this.getNonce(address, new Epoch[0]).sendAndGet().compareTo(nonceUntil) < 0) {
            Thread.sleep(intervalMillis);
        }
    }

    default public SendTransactionResult sendRawTransactionAndGet(String hexEncoded) throws RpcException {
        StringResponse response = this.sendRawTransaction(hexEncoded).sendWithRetry();
        return response.getError() == null ? new SendTransactionResult((String)response.getValue()) : new SendTransactionResult(response.getError());
    }
}

