/*
 * Decompiled with CFR 0.152.
 */
package conflux.web3j;

import com.fasterxml.jackson.databind.ObjectMapper;
import conflux.web3j.UnlockedItem;
import conflux.web3j.types.Address;
import conflux.web3j.types.AddressType;
import conflux.web3j.types.RawTransaction;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.crypto.WalletUtils;
import org.web3j.utils.Numeric;

public class AccountManager {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String keyfilePrefix = "conflux-keyfile-";
    private static final String keyfileExt = ".json";
    private String dir;
    private ConcurrentHashMap<String, UnlockedItem> unlocked;
    private int networkId;

    public AccountManager(int networkId) throws Exception {
        this(AccountManager.getDefaultDirectory(), networkId);
    }

    public AccountManager(String dir, int networkId) throws IOException {
        Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
        this.dir = dir;
        this.networkId = networkId;
        this.unlocked = new ConcurrentHashMap();
    }

    public String getDirectory() {
        return this.dir;
    }

    public static String getDefaultDirectory() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac")) {
            return String.format("%s%sLibrary%sConflux", System.getProperty("user.home"), File.separator, File.separator);
        }
        if (osName.startsWith("win")) {
            return String.format("%s%sConflux", System.getenv("APPDATA"), File.separator);
        }
        return String.format("%s%s.conflux", System.getProperty("user.home"), File.separator);
    }

    public Address create(String password) throws Exception {
        return this.createKeyFile(password, Keys.createEcKeyPair());
    }

    private Address createKeyFile(String password, ECKeyPair ecKeyPair) throws Exception {
        WalletFile walletFile = Wallet.createStandard((String)password, (ECKeyPair)ecKeyPair);
        walletFile.setAddress(AddressType.User.normalize(walletFile.getAddress()));
        String filename = String.format("%s%s%s", keyfilePrefix, walletFile.getAddress(), keyfileExt);
        File keyfile = new File(this.dir, filename);
        objectMapper.writeValue(keyfile, (Object)walletFile);
        return new Address(walletFile.getAddress(), this.networkId);
    }

    public List<Address> list() throws IOException {
        return Files.list(Paths.get(this.dir, new String[0])).map(path -> this.parseAddressFromFilename(path.getFileName().toString())).filter(path -> !path.isEmpty()).sorted().map(hexAddress -> new Address((String)hexAddress, this.networkId)).collect(Collectors.toList());
    }

    private String parseAddressFromFilename(String filename) {
        if (!filename.startsWith(keyfilePrefix) || !filename.endsWith(keyfileExt)) {
            return "";
        }
        String hexAddress = filename.substring(keyfilePrefix.length(), filename.length() - keyfileExt.length());
        try {
            AddressType.validateHexAddress(hexAddress, AddressType.User);
        }
        catch (Exception e) {
            return "";
        }
        return hexAddress;
    }

    private Optional<Address> imports(Credentials credentials, String password) throws Exception {
        String hexAddress = AddressType.User.normalize(credentials.getAddress());
        Address address = new Address(hexAddress, this.networkId);
        if (this.exists(address)) {
            return Optional.empty();
        }
        this.createKeyFile(password, credentials.getEcKeyPair());
        return Optional.of(address);
    }

    public Optional<Address> imports(String keyFile, String password, String newPassword) throws Exception {
        Credentials importedCredentials = WalletUtils.loadCredentials((String)password, (String)keyFile);
        return this.imports(importedCredentials, newPassword);
    }

    public Optional<Address> imports(String privateKey, String password) throws Exception {
        return this.imports(Credentials.create((String)privateKey), password);
    }

    public boolean exists(Address address) throws Exception {
        return Files.list(Paths.get(this.dir, new String[0])).map(path -> this.parseAddressFromFilename(path.getFileName().toString())).anyMatch(path -> path.equalsIgnoreCase(address.getHexAddress()));
    }

    public boolean delete(Address address) throws Exception {
        String hexAddress = address.getHexAddress();
        List files = Files.list(Paths.get(this.dir, new String[0])).filter(path -> this.parseAddressFromFilename(path.getFileName().toString()).equalsIgnoreCase(hexAddress)).collect(Collectors.toList());
        if (files.isEmpty()) {
            return false;
        }
        for (Path file : files) {
            Files.delete(file);
        }
        this.unlocked.remove(hexAddress);
        return true;
    }

    public boolean update(Address address, String password, String newPassword) throws Exception {
        List files = Files.list(Paths.get(this.dir, new String[0])).filter(path -> this.parseAddressFromFilename(path.getFileName().toString()).equalsIgnoreCase(address.getHexAddress())).collect(Collectors.toList());
        if (files.isEmpty()) {
            return false;
        }
        ECKeyPair ecKeyPair = WalletUtils.loadCredentials((String)password, (String)((Path)files.get(0)).toString()).getEcKeyPair();
        Files.delete((Path)files.get(0));
        this.createKeyFile(newPassword, ecKeyPair);
        return true;
    }

    public String exportPrivateKey(Address address, String password) throws Exception {
        List files = Files.list(Paths.get(this.dir, new String[0])).filter(path -> this.parseAddressFromFilename(path.getFileName().toString()).equalsIgnoreCase(address.getHexAddress())).collect(Collectors.toList());
        if (files.isEmpty()) {
            return null;
        }
        ECKeyPair ecKeyPair = WalletUtils.loadCredentials((String)password, (String)((Path)files.get(0)).toString()).getEcKeyPair();
        return "0x" + ecKeyPair.getPrivateKey().toString(16);
    }

    public boolean unlock(Address address, String password, Duration ... timeout) throws Exception {
        String hexAddress = address.getHexAddress();
        List files = Files.list(Paths.get(this.dir, new String[0])).filter(path -> this.parseAddressFromFilename(path.getFileName().toString()).equalsIgnoreCase(hexAddress)).collect(Collectors.toList());
        if (files.isEmpty()) {
            return false;
        }
        Credentials credentials = WalletUtils.loadCredentials((String)password, (String)((Path)files.get(0)).toString());
        UnlockedItem item = timeout != null && timeout.length > 0 && timeout[0] != null && timeout[0].compareTo(Duration.ZERO) > 0 ? new UnlockedItem(credentials.getEcKeyPair(), Optional.of(timeout[0])) : new UnlockedItem(credentials.getEcKeyPair(), Optional.empty());
        this.unlocked.put(hexAddress, item);
        return true;
    }

    public boolean lock(Address address) {
        UnlockedItem item = this.unlocked.remove(address.getHexAddress());
        return item != null && !item.expired();
    }

    public String signTransaction(RawTransaction tx, Address address, String ... password) throws Exception {
        ECKeyPair ecKeyPair = this.getEcKeyPair(address, password);
        return tx.sign(ecKeyPair);
    }

    private ECKeyPair getEcKeyPair(Address cfxAddress, String ... password) throws IOException, CipherException {
        List files;
        String address = cfxAddress.getHexAddress();
        UnlockedItem item = this.unlocked.get(address);
        if (password == null || password.length == 0 || password[0] == null || password[0].isEmpty()) {
            if (item == null) {
                throw new IllegalArgumentException("password not specified for locked account");
            }
            if (item.expired()) {
                this.unlocked.remove(address);
                throw new IllegalArgumentException("password expired for unlocked account");
            }
            return item.getEcKeyPair();
        }
        if (item != null) {
            if (!item.expired()) {
                return item.getEcKeyPair();
            }
            this.unlocked.remove(address);
        }
        if ((files = Files.list(Paths.get(this.dir, new String[0])).filter(path -> this.parseAddressFromFilename(path.getFileName().toString()).equalsIgnoreCase(address)).collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException("account not found");
        }
        return WalletUtils.loadCredentials((String)password[0], (String)((Path)files.get(0)).toString()).getEcKeyPair();
    }

    public String signMessage(byte[] message, boolean needToHash, Address address, String ... password) throws Exception {
        ECKeyPair ecKeyPair = this.getEcKeyPair(address, password);
        return AccountManager.signMessage(message, needToHash, ecKeyPair);
    }

    public static String signMessage(byte[] message, boolean needToHash, ECKeyPair ecKeyPair) {
        Sign.SignatureData data = Sign.signMessage((byte[])message, (ECKeyPair)ecKeyPair, (boolean)needToHash);
        byte[] rsv = new byte[data.getR().length + data.getS().length + data.getV().length];
        System.arraycopy(data.getR(), 0, rsv, 0, data.getR().length);
        System.arraycopy(data.getS(), 0, rsv, data.getR().length, data.getS().length);
        System.arraycopy(data.getV(), 0, rsv, data.getR().length + data.getS().length, data.getV().length);
        return Numeric.toHexString((byte[])rsv);
    }
}

