/*
 * Decompiled with CFR 0.152.
 */
package io.cryptocontrol.cryptonewsapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.cryptocontrol.cryptonewsapi.exceptions.BadResponseException;
import io.cryptocontrol.cryptonewsapi.exceptions.InvalidAPIKeyException;
import io.cryptocontrol.cryptonewsapi.exceptions.NotPremiumException;
import io.cryptocontrol.cryptonewsapi.exceptions.RateLimitException;
import io.cryptocontrol.cryptonewsapi.models.Article;
import io.cryptocontrol.cryptonewsapi.models.CategoryResponse;
import io.cryptocontrol.cryptonewsapi.models.CoinDetail;
import io.cryptocontrol.cryptonewsapi.models.CombinedFeedResponse;
import io.cryptocontrol.cryptonewsapi.models.Feed;
import io.cryptocontrol.cryptonewsapi.models.Language;
import io.cryptocontrol.cryptonewsapi.models.RedditPost;
import io.cryptocontrol.cryptonewsapi.models.Tweet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class CryptoControlApi {
    private final String apiKey;
    private String proxyURL = null;
    private final Gson gson = new GsonBuilder().create();
    private boolean enableSentiment = false;

    public CryptoControlApi(String apiKey) {
        if (apiKey == null) {
            throw new Error("No API key found. Register for an API key at https://cryptocontrol.io/apis");
        }
        this.apiKey = apiKey;
    }

    public CryptoControlApi(String apiKey, String proxyURL) {
        this(apiKey);
        this.proxyURL = proxyURL;
    }

    public void enableSentiment() {
        this.enableSentiment = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(String path, Language lang, OnResponseHandler callback, Type TypeofT) {
        String langSlug;
        String jsonStr = "";
        HttpURLConnection urlConnection = null;
        switch (lang) {
            default: {
                langSlug = "en";
                break;
            }
            case RUSSIAN: {
                langSlug = "ru";
                break;
            }
            case GERMAN: {
                langSlug = "de";
                break;
            }
            case SPANISH: {
                langSlug = "es";
                break;
            }
            case ITALIAN: {
                langSlug = "it";
                break;
            }
            case PORTUGUESE: {
                langSlug = "po";
                break;
            }
            case CHINESE: {
                langSlug = "cn";
                break;
            }
            case JAPANESE: {
                langSlug = "jp";
                break;
            }
            case KOREAN: {
                langSlug = "ko";
            }
        }
        try {
            String HOST = this.proxyURL != null ? this.proxyURL : "https://cryptocontrol.io/api/v1/public";
            URL url = new URL(HOST + path + (path.contains("?") ? "&" : "?") + "language=" + langSlug + "&sentiment=" + this.enableSentiment);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("x-api-key", this.apiKey);
            String USER_AGENT = "CryptoControl Java API v2.5.0";
            urlConnection.setRequestProperty("user-agent", USER_AGENT);
            int code = urlConnection.getResponseCode();
            switch (code) {
                case 200: {
                    break;
                }
                case 429: {
                    throw new RateLimitException();
                }
                case 401: {
                    throw new InvalidAPIKeyException();
                }
                case 405: {
                    throw new NotPremiumException();
                }
                default: {
                    throw new BadResponseException();
                }
            }
            BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                jsonStr = jsonStr + line;
            }
            ((InputStream)in).close();
            callback.onSuccess(this.gson.fromJson(jsonStr, TypeofT));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public void getTopNews(OnResponseHandler<List<Article>> callback) {
        this.getTopNews(Language.ENGLISH, callback);
    }

    public void getTopNews(Language lang, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news", lang, callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getLatestNews(OnResponseHandler<List<Article>> callback) {
        this.getLatestNews(Language.ENGLISH, callback);
    }

    public void getLatestNews(Language lang, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news?latest=true", lang, callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getTopNewsByCategory(OnResponseHandler<CategoryResponse> callback) {
        this.getTopNewsByCategory(Language.ENGLISH, callback);
    }

    public void getTopNewsByCategory(Language lang, OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/category", lang, callback, (Type)((Object)CategoryResponse.class));
    }

    public void getLatestNewsByCategory(OnResponseHandler<CategoryResponse> callback) {
        this.getLatestNewsByCategory(Language.ENGLISH, callback);
    }

    public void getLatestNewsByCategory(Language lang, OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/category?latest=true", lang, callback, (Type)((Object)CategoryResponse.class));
    }

    public void getTopNewsByCoin(String coinName, OnResponseHandler<List<Article>> callback) {
        this.getTopNewsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getTopNewsByCoin(Language lang, String coinName, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news/coin/" + coinName, lang, callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getLatestNewsByCoin(String coinName, OnResponseHandler<List<Article>> callback) {
        this.getLatestNewsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getLatestNewsByCoin(Language lang, String coinName, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news/coin/" + coinName + "?latest=true", lang, callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getTopNewsByCoinCategory(String coinName, OnResponseHandler<CategoryResponse> callback) {
        this.getTopNewsByCoinCategory(Language.ENGLISH, coinName, callback);
    }

    public void getTopNewsByCoinCategory(Language lang, String coinName, OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/coin/" + coinName + "/category", lang, callback, (Type)((Object)CategoryResponse.class));
    }

    public void getTopRedditPostsByCoin(String coinName, OnResponseHandler<List<RedditPost>> callback) {
        this.getTopRedditPostsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getTopRedditPostsByCoin(Language lang, String coinName, OnResponseHandler<List<RedditPost>> callback) {
        this.fetch("/reddit/coin/" + coinName, lang, callback, (Type)((Object)RedditPost.RedditPostList.class));
    }

    public void getLatestRedditPostsByCoin(String coinName, OnResponseHandler<List<RedditPost>> callback) {
        this.getLatestRedditPostsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getLatestRedditPostsByCoin(Language lang, String coinName, OnResponseHandler<List<RedditPost>> callback) {
        this.fetch("/reddit/coin/" + coinName + "?latest=true", lang, callback, (Type)((Object)RedditPost.RedditPostList.class));
    }

    public void getTopTweetsByCoin(String coinName, OnResponseHandler<List<Tweet>> callback) {
        this.getTopTweetsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getTopTweetsByCoin(Language lang, String coinName, OnResponseHandler<List<Tweet>> callback) {
        this.fetch("/tweets/coin/" + coinName, lang, callback, (Type)((Object)Tweet.TweetList.class));
    }

    public void getLatestTweetsByCoin(String coinName, OnResponseHandler<List<Tweet>> callback) {
        this.getLatestTweetsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getLatestTweetsByCoin(Language lang, String coinName, OnResponseHandler<List<Tweet>> callback) {
        this.fetch("/tweets/coin/" + coinName + "?latest=true", lang, callback, (Type)((Object)Tweet.TweetList.class));
    }

    public void getTopFeedByCoin(String coinName, OnResponseHandler<List<Feed>> callback) {
        this.getTopFeedByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getTopFeedByCoin(Language lang, String coinName, OnResponseHandler<List<Feed>> callback) {
        this.fetch("/feed/coin/" + coinName, lang, callback, (Type)((Object)Feed.FeedList.class));
    }

    public void getLatestFeedByCoin(String coinName, OnResponseHandler<List<Feed>> callback) {
        this.getLatestFeedByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getLatestFeedByCoin(Language lang, String coinName, OnResponseHandler<List<Feed>> callback) {
        this.fetch("/feed/coin/" + coinName + "?latest=true", lang, callback, (Type)((Object)Feed.FeedList.class));
    }

    public void getTopItemsByCoin(String coinName, OnResponseHandler<CombinedFeedResponse> callback) {
        this.getTopItemsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getTopItemsByCoin(Language lang, String coinName, OnResponseHandler<CombinedFeedResponse> callback) {
        this.fetch("/all/coin/" + coinName, lang, callback, (Type)((Object)CombinedFeedResponse.class));
    }

    public void getLatestItemsByCoin(String coinName, OnResponseHandler<CombinedFeedResponse> callback) {
        this.getLatestItemsByCoin(Language.ENGLISH, coinName, callback);
    }

    public void getLatestItemsByCoin(Language lang, String coinName, OnResponseHandler<CombinedFeedResponse> callback) {
        this.fetch("/all/coin/" + coinName + "?latest=true", lang, callback, (Type)((Object)CombinedFeedResponse.class));
    }

    public void getCoinDetails(String coinName, OnResponseHandler<CoinDetail> callback) {
        this.fetch("/details/coin/" + coinName, Language.ENGLISH, callback, (Type)((Object)CoinDetail.class));
    }

    public static interface OnResponseHandler<T> {
        public void onSuccess(T var1);

        public void onFailure(Exception var1);
    }
}

