/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.connection;

import io.allune.quickfixj.spring.boot.starter.exception.SettingsNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import quickfix.ConfigError;
import quickfix.SessionSettings;

public class SessionSettingsLocator {
    private static final Log logger = LogFactory.getLog(SessionSettingsLocator.class);

    private SessionSettingsLocator() {
    }

    public static SessionSettings loadSettings(String applicationConfigLocation, String systemProperty, String fileSystemLocation, String classpathLocation) {
        try {
            SessionSettings settings = SessionSettingsLocator.loadFromApplicationConfig(applicationConfigLocation);
            if (settings != null) {
                return settings;
            }
            settings = SessionSettingsLocator.loadFromSystemProperty(systemProperty);
            if (settings != null) {
                return settings;
            }
            settings = SessionSettingsLocator.loadFromFileSystem(fileSystemLocation);
            if (settings != null) {
                return settings;
            }
            settings = SessionSettingsLocator.loadFromClassPath(classpathLocation);
            if (settings != null) {
                return settings;
            }
            throw new SettingsNotFoundException("Settings file not found");
        }
        catch (IOException | RuntimeException | ConfigError e) {
            throw new SettingsNotFoundException(e.getMessage(), e);
        }
    }

    private static SessionSettings loadFromApplicationConfig(String applicationConfigLocation) throws ConfigError, IOException {
        Resource resource;
        if (applicationConfigLocation != null && (resource = SessionSettingsLocator.loadResource(applicationConfigLocation)) != null && resource.exists()) {
            logger.info((Object)("Loading settings from application property '" + applicationConfigLocation + "'"));
            return new SessionSettings(resource.getInputStream());
        }
        return null;
    }

    private static SessionSettings loadFromSystemProperty(String systemProperty) throws ConfigError, IOException {
        Resource resource;
        String configSystemProperty;
        if (systemProperty != null && (configSystemProperty = System.getProperty(systemProperty)) != null && (resource = SessionSettingsLocator.loadResource(configSystemProperty)) != null && resource.exists()) {
            logger.info((Object)("Loading settings from System property '" + systemProperty + "'"));
            return new SessionSettings(resource.getInputStream());
        }
        return null;
    }

    private static SessionSettings loadFromFileSystem(String fileSystemLocation) throws ConfigError, IOException {
        Resource resource;
        if (fileSystemLocation != null && (resource = SessionSettingsLocator.loadResource(fileSystemLocation)) != null && resource.exists()) {
            logger.info((Object)("Loading settings from default filesystem location '" + fileSystemLocation + "'"));
            return new SessionSettings(resource.getInputStream());
        }
        return null;
    }

    private static SessionSettings loadFromClassPath(String classpathLocation) throws ConfigError, IOException {
        Resource resource;
        if (classpathLocation != null && (resource = SessionSettingsLocator.loadResource(classpathLocation)) != null && resource.exists()) {
            logger.info((Object)("Loading settings from default classpath location '" + classpathLocation + "'"));
            return new SessionSettings(resource.getInputStream());
        }
        return null;
    }

    private static Resource loadResource(String location) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        return resolver.getResource(location);
    }
}

