/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.connection;

import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.RuntimeError;

public class ConnectorManager
implements SmartLifecycle {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Connector connector;
    private final Object lifecycleMonitor = new Object();
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private boolean running = false;

    public ConnectorManager(Connector connector) {
        Assert.notNull((Object)connector, (String)"'connector' must not be null");
        this.connector = connector;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"start: Starting ConnectorManager");
                }
                try {
                    this.connector.start();
                }
                catch (ConfigError | RuntimeError ex) {
                    throw new ConfigurationException(ex.getMessage(), ex);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Could not start the connector", ex);
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"stop: Stopping ConnectorManager");
                }
                try {
                    this.connector.stop();
                }
                finally {
                    this.running = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }
}

