/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.autoconfigure.server;

import io.allune.quickfixj.spring.boot.starter.autoconfigure.QuickFixJBootProperties;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.server.QuickFixJServerMarkerConfiguration;
import io.allune.quickfixj.spring.boot.starter.connection.ConnectorManager;
import io.allune.quickfixj.spring.boot.starter.connection.SessionSettingsLocator;
import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import javax.management.JMException;
import javax.management.ObjectName;
import org.quickfixj.jmx.JmxExporter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.ResourceCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ApplicationAdapter;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;
import quickfix.SocketAcceptor;

@Configuration
@EnableConfigurationProperties(value={QuickFixJBootProperties.class})
@ConditionalOnBean(value={QuickFixJServerMarkerConfiguration.Marker.class})
@Conditional(value={ServerConfigAvailableCondition.class})
public class QuickFixJServerAutoConfiguration {
    private static final String SYSTEM_VARIABLE_QUICKFIXJ_SERVER_CONFIG = "quickfixj.server.config";
    private static final String QUICKFIXJ_SERVER_CONFIG = "quickfixj-server.cfg";

    @Bean
    @ConditionalOnMissingBean(name={"serverSessionSettings"})
    public SessionSettings serverSessionSettings(QuickFixJBootProperties properties) {
        return SessionSettingsLocator.loadSettings(properties.getServer().getConfig(), SYSTEM_VARIABLE_QUICKFIXJ_SERVER_CONFIG, "file:./quickfixj-server.cfg", "classpath:/quickfixj-server.cfg");
    }

    @Bean
    @ConditionalOnMissingBean(name={"serverApplication"})
    public Application serverApplication() {
        return new ApplicationAdapter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"serverMessageStoreFactory"})
    public MessageStoreFactory serverMessageStoreFactory() {
        return new MemoryStoreFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"serverLogFactory"})
    public LogFactory serverLogFactory() {
        return new ScreenLogFactory(true, true, true);
    }

    @Bean
    @ConditionalOnMissingBean(name={"serverMessageFactory"})
    public MessageFactory serverMessageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"serverAcceptor"})
    public Acceptor serverAcceptor(Application serverApplication, MessageStoreFactory serverMessageStoreFactory, SessionSettings serverSessionSettings, LogFactory serverLogFactory, MessageFactory serverMessageFactory) {
        try {
            return new SocketAcceptor(serverApplication, serverMessageStoreFactory, serverSessionSettings, serverLogFactory, serverMessageFactory);
        }
        catch (ConfigError configError) {
            throw new ConfigurationException(configError.getMessage(), configError);
        }
    }

    @Bean
    public ConnectorManager serverConnectionManager(Acceptor serverAcceptor, QuickFixJBootProperties properties) {
        ConnectorManager connectorManager = new ConnectorManager((Connector)serverAcceptor);
        connectorManager.setAutoStartup(properties.getServer().isAutoStartup());
        connectorManager.setPhase(properties.getServer().getPhase());
        return connectorManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.server", name={"jmx-enabled"}, havingValue="true")
    @ConditionalOnClass(value={JmxExporter.class})
    @ConditionalOnSingleCandidate(value=Acceptor.class)
    @ConditionalOnMissingBean(name={"serverInitiatorMBean"})
    public ObjectName serverInitiatorMBean(Acceptor serverAcceptor) {
        try {
            JmxExporter exporter = new JmxExporter();
            return exporter.register((Connector)serverAcceptor);
        }
        catch (JMException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    static class ServerConfigAvailableCondition
    extends ResourceCondition {
        ServerConfigAvailableCondition() {
            super("QuickFixJ", "quickfixj.server", "config", new String[]{"file:./quickfixj-server.cfg", "classpath:/quickfixj-server.cfg"});
        }
    }
}

