/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.autoconfigure.client;

import io.allune.quickfixj.spring.boot.starter.autoconfigure.QuickFixJBootProperties;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.QuickFixJConfigResourceCondition;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.client.QuickFixJClientMarkerConfiguration;
import io.allune.quickfixj.spring.boot.starter.connection.ConnectorManager;
import io.allune.quickfixj.spring.boot.starter.connection.SessionSettingsLocator;
import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import javax.management.JMException;
import javax.management.ObjectName;
import org.quickfixj.jmx.JmxExporter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import quickfix.Application;
import quickfix.ApplicationAdapter;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionSettings;
import quickfix.SocketInitiator;

@Configuration
@EnableConfigurationProperties(value={QuickFixJBootProperties.class})
@ConditionalOnBean(value={QuickFixJClientMarkerConfiguration.Marker.class})
@Conditional(value={ClientConfigAvailableCondition.class})
public class QuickFixJClientAutoConfiguration {
    private static final String SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG = "quickfixj.client.config";
    private static final String QUICKFIXJ_CLIENT_CONFIG = "quickfixj-client.cfg";

    @Bean
    @ConditionalOnMissingBean(name={"clientSessionSettings"})
    public SessionSettings clientSessionSettings(QuickFixJBootProperties properties) {
        return SessionSettingsLocator.loadSettings(properties.getClient().getConfig(), SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG, "file:./quickfixj-client.cfg", "classpath:/quickfixj-client.cfg");
    }

    @Bean
    @ConditionalOnMissingBean(name={"clientApplication"})
    public Application clientApplication() {
        return new ApplicationAdapter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"clientMessageStoreFactory"})
    public MessageStoreFactory clientMessageStoreFactory() {
        return new MemoryStoreFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"clientLogFactory"})
    public LogFactory clientLogFactory() {
        return new ScreenLogFactory(true, true, true);
    }

    @Bean
    @ConditionalOnMissingBean(name={"clientMessageFactory"})
    public MessageFactory clientMessageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    @ConditionalOnMissingBean(name={"clientInitiator"})
    public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory) throws ConfigError {
        return new SocketInitiator(clientApplication, clientMessageStoreFactory, clientSessionSettings, clientLogFactory, clientMessageFactory);
    }

    @Bean
    public ConnectorManager clientConnectionManager(Initiator clientInitiator, QuickFixJBootProperties properties) {
        ConnectorManager connectorManager = new ConnectorManager((Connector)clientInitiator);
        if (properties.getClient() != null) {
            connectorManager.setAutoStartup(properties.getClient().isAutoStartup());
            connectorManager.setPhase(properties.getClient().getPhase());
        }
        return connectorManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="quickfixj.client", name={"jmx-enabled"}, havingValue="true")
    @ConditionalOnClass(value={JmxExporter.class})
    @ConditionalOnSingleCandidate(value=Initiator.class)
    @ConditionalOnMissingBean(name={"clientInitiatorMBean"})
    public ObjectName clientInitiatorMBean(Initiator clientInitiator) {
        try {
            JmxExporter exporter = new JmxExporter();
            return exporter.register((Connector)clientInitiator);
        }
        catch (JMException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    static class ClientConfigAvailableCondition
    extends QuickFixJConfigResourceCondition {
        ClientConfigAvailableCondition() {
            super(QuickFixJClientAutoConfiguration.SYSTEM_VARIABLE_QUICKFIXJ_CLIENT_CONFIG, "quickfixj.client", "config", "file:./quickfixj-client.cfg", "classpath:/quickfixj-client.cfg");
        }
    }
}

