/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ResourceCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

public abstract class QuickFixJConfigResourceCondition
extends ResourceCondition {
    private final String configSystemProperty;

    public QuickFixJConfigResourceCondition(String configSystemProperty, String prefix, String propertyName, String ... resourceLocations) {
        super("QuickFixJ", prefix, propertyName, resourceLocations);
        Assert.notNull((Object)configSystemProperty, (String)"ConfigSystemProperty must not be null");
        this.configSystemProperty = configSystemProperty;
    }

    protected ConditionOutcome getResourceOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (System.getProperty(this.configSystemProperty) != null) {
            return ConditionOutcome.match((ConditionMessage)this.startConditionMessage().because("System property '" + this.configSystemProperty + "' is set."));
        }
        return super.getResourceOutcome(context, metadata);
    }
}

