/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class ChannelEndpointStatus {
    public static final long INITIALIZING = 0L;
    public static final long ERRORED = -1L;
    public static final long ACTIVE = 1L;
    public static final long CLOSING = 2L;
    public static final int NO_ID_ALLOCATED = -1;
    public static final int CHANNEL_OFFSET = 0;
    public static final int MAX_CHANNEL_LENGTH = 108;

    public static String status(long status) {
        if (0L == status) {
            return "INITIALIZING";
        }
        if (-1L == status) {
            return "ERRORED";
        }
        if (1L == status) {
            return "ACTIVE";
        }
        if (2L == status) {
            return "CLOSING";
        }
        return "unknown id=" + status;
    }

    public static AtomicCounter allocate(MutableDirectBuffer tempBuffer, String name, int typeId, CountersManager countersManager, String channel) {
        int keyLength = tempBuffer.putStringWithoutLengthAscii(4, channel, 0, 108);
        tempBuffer.putInt(0, keyLength);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(keyLength + labelLength, name);
        labelLength += tempBuffer.putStringWithoutLengthAscii(keyLength + labelLength, ": ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(keyLength + labelLength, channel, 0, 380 - labelLength);
        return countersManager.newCounter(typeId, tempBuffer, 0, keyLength, tempBuffer, keyLength, labelLength);
    }
}

