/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.shadow.net.bytebuddy.implementation.bytecode.constant;

import io.aeron.shadow.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.aeron.shadow.net.bytebuddy.implementation.Implementation;
import io.aeron.shadow.net.bytebuddy.implementation.bytecode.StackManipulation;
import io.aeron.shadow.net.bytebuddy.implementation.bytecode.StackSize;
import io.aeron.shadow.net.bytebuddy.jar.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FloatConstant implements StackManipulation
{
    ZERO(11),
    ONE(12),
    TWO(13);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private FloatConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(float value) {
        if (value == 0.0f) {
            return ZERO;
        }
        if (value == 1.0f) {
            return ONE;
        }
        if (value == 2.0f) {
            return TWO;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    implements StackManipulation {
        private final float value;

        protected ConstantPool(float value) {
            this.value = value;
        }

        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(Float.valueOf(this.value));
            return SIZE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.value == ((ConstantPool)object).value;
        }

        public int hashCode() {
            return 17 * 31 + Float.floatToIntBits(this.value);
        }
    }
}

