/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import io.aeron.shadow.org.HdrHistogram.Histogram;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.IntSupplier;
import org.agrona.concurrent.SigInt;

public class SendSelectReceiveUdpPing {
    private static final InetSocketAddress SEND_ADDRESS = new InetSocketAddress("localhost", 50123);
    private int sequenceNumber;

    public static void main(String[] args) throws IOException {
        new SendSelectReceiveUdpPing().run();
    }

    private void run() throws IOException {
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        DatagramChannel receiveChannel = DatagramChannel.open();
        Common.init(receiveChannel);
        receiveChannel.bind(new InetSocketAddress("localhost", 40123));
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        IntSupplier handler = () -> {
            try {
                buffer.clear();
                receiveChannel.receive(buffer);
                long receivedSequenceNumber = buffer.getLong(0);
                long timestamp = buffer.getLong(8);
                if (receivedSequenceNumber != (long)this.sequenceNumber) {
                    throw new IllegalStateException("Data Loss:" + this.sequenceNumber + " to " + receivedSequenceNumber);
                }
                long duration = System.nanoTime() - timestamp;
                histogram.recordValue(duration);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 1;
        };
        receiveChannel.register(selector, 1, handler);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            this.measureRoundTrip(histogram, SEND_ADDRESS, buffer, sendChannel, selector, running);
            histogram.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    private void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, DatagramChannel sendChannel, Selector selector, AtomicBoolean running) throws IOException {
        this.sequenceNumber = 0;
        while (this.sequenceNumber < 10000) {
            long timestamp = System.nanoTime();
            buffer.clear();
            buffer.putLong(this.sequenceNumber);
            buffer.putLong(timestamp);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
            while (selector.selectNow() == 0) {
                if (running.get()) continue;
                return;
            }
            Set<SelectionKey> selectedKeys = selector.selectedKeys();
            Iterator<SelectionKey> iter = selectedKeys.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                if (key.isReadable()) {
                    ((IntSupplier)key.attachment()).getAsInt();
                }
                iter.remove();
            }
            ++this.sequenceNumber;
        }
        histogram.outputPercentileDistribution(System.out, 1000.0);
    }
}

