/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.logbuffer.Header;
import io.aeron.samples.SampleConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;

public class FileReceiver {
    public static final int VERSION = 0;
    public static final int FILE_CREATE_TYPE = 1;
    public static final int FILE_CHUNK_TYPE = 2;
    public static final int VERSION_OFFSET = 0;
    public static final int TYPE_OFFSET = 4;
    public static final int CORRELATION_ID_OFFSET = 8;
    public static final int FILE_LENGTH_OFFSET = 16;
    public static final int FILE_NAME_OFFSET = 24;
    public static final int CHUNK_OFFSET_OFFSET = 16;
    public static final int CHUNK_LENGTH_OFFSET = 24;
    public static final int CHUNK_PAYLOAD_OFFSET = 32;
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final int FRAGMENT_LIMIT = 10;
    private final File storageDir;
    private final Subscription subscription;
    private final FragmentAssembler assembler = new FragmentAssembler(this::onFragment);
    private final Long2ObjectHashMap<UnsafeBuffer> fileSessionByIdMap = new Long2ObjectHashMap();

    public FileReceiver(File storageDir, Subscription subscription) {
        this.storageDir = storageDir;
        this.subscription = subscription;
    }

    public static void main(String[] args) {
        File storageDir;
        if (args.length > 1) {
            storageDir = new File(args[0]);
            if (!storageDir.isDirectory()) {
                System.out.println(args[0] + " is not a directory");
                System.exit(1);
            }
        } else {
            storageDir = new File(IoUtil.tmpDirName());
        }
        System.out.println("Files stored to " + storageDir.getAbsolutePath());
        SleepingMillisIdleStrategy idleStrategy = new SleepingMillisIdleStrategy(1L);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        try (MediaDriver ignore = MediaDriver.launch();
             Aeron aeron = Aeron.connect();
             Subscription subscription = aeron.addSubscription(CHANNEL, STREAM_ID);){
            System.out.println("Receiving from " + CHANNEL + " on stream Id " + STREAM_ID);
            FileReceiver fileReceiver = new FileReceiver(storageDir, subscription);
            while (running.get()) {
                idleStrategy.idle(fileReceiver.doWork());
            }
        }
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int version = buffer.getInt(offset + 0, ByteOrder.LITTLE_ENDIAN);
        if (0 != version) {
            throw new IllegalArgumentException("unsupported version " + version + " expected " + 0);
        }
        int messageType = buffer.getInt(offset + 4, ByteOrder.LITTLE_ENDIAN);
        switch (messageType) {
            case 1: {
                this.createFile(buffer.getLong(offset + 8, ByteOrder.LITTLE_ENDIAN), buffer.getLong(offset + 16, ByteOrder.LITTLE_ENDIAN), buffer.getStringUtf8(offset + 24, ByteOrder.LITTLE_ENDIAN));
                break;
            }
            case 2: {
                this.fileChunk(buffer.getLong(offset + 8, ByteOrder.LITTLE_ENDIAN), buffer.getLong(offset + 16, ByteOrder.LITTLE_ENDIAN), buffer.getLong(offset + 24, ByteOrder.LITTLE_ENDIAN), buffer, offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown message type: " + messageType);
            }
        }
    }

    private void createFile(long correlationId, long length, String filename) {
        if (this.fileSessionByIdMap.containsKey(correlationId)) {
            throw new IllegalStateException("correlationId is in use: " + correlationId);
        }
        File file = new File(this.storageDir, filename);
        if (file.exists() && !file.delete()) {
            throw new IllegalStateException("failed to delete existing file: " + file);
        }
        if (length == 0L) {
            try {
                if (!file.createNewFile()) {
                    throw new IllegalStateException("failed to create " + filename);
                }
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        } else {
            this.fileSessionByIdMap.put(correlationId, new UnsafeBuffer(IoUtil.mapNewFile(file, length, false)));
        }
    }

    private void fileChunk(long correlationId, long chunkOffset, long chunkLength, DirectBuffer buffer, int offset) {
        UnsafeBuffer fileBuffer = this.fileSessionByIdMap.get(correlationId);
        buffer.getBytes(offset + 32, fileBuffer, (int)chunkOffset, (int)chunkLength);
        if (chunkOffset + chunkLength >= (long)fileBuffer.capacity()) {
            this.fileSessionByIdMap.remove(correlationId);
            IoUtil.unmap(fileBuffer.byteBuffer());
        }
    }

    private int doWork() {
        return this.subscription.poll(this.assembler, 10);
    }
}

