/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;

public class ErrorStat {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");

    public static void main(String[] args) {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "cnc");
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (15 != cncVersion) {
            throw new IllegalStateException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 15);
        }
        UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer);
        int distinctErrorCount = ErrorLogReader.read(buffer, ErrorStat::accept);
        System.out.format("%n%d distinct errors observed.%n", distinctErrorCount);
    }

    private static void accept(int observationCount, long firstObservationTimestamp, long lastObservationTimestamp, String encodedException) {
        System.out.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, DATE_FORMAT.format(new Date(firstObservationTimestamp)), DATE_FORMAT.format(new Date(lastObservationTimestamp)), encodedException);
    }
}

