/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.util.Date;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class DriverTool {
    public static void main(String[] args) {
        File cncFile;
        MappedByteBuffer cncByteBuffer;
        UnsafeBuffer cncMetaData;
        int cncVersion;
        boolean printPidOnly = false;
        if (0 != args.length) {
            DriverTool.checkForHelp(args);
            if (args[0].equals("pid")) {
                printPidOnly = true;
            }
        }
        if (15 != (cncVersion = (cncMetaData = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer = IoUtil.mapExistingFile(cncFile = CommonContext.newDefaultCncFile(), "cnc"))).getInt(CncFileDescriptor.cncVersionOffset(0)))) {
            throw new IllegalStateException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 15);
        }
        ManyToOneRingBuffer toDriver = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(cncByteBuffer, cncMetaData));
        if (printPidOnly) {
            System.out.println(CncFileDescriptor.pid(cncMetaData));
        } else {
            System.out.println("Command `n Control file: " + cncFile);
            System.out.format("Version: %d, PID: %d%n", cncVersion, CncFileDescriptor.pid(cncMetaData));
            DriverTool.printDateActivityAndStartTimestamps(CncFileDescriptor.startTimestamp(cncMetaData), toDriver.consumerHeartbeatTime());
        }
    }

    private static void printDateActivityAndStartTimestamps(long startTimestamp, long activityTimestamp) {
        System.out.format("%1$tH:%1$tM:%1$tS (start: %2tF %2$tH:%2$tM:%2$tS, activity: %3tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(startTimestamp), new Date(activityTimestamp));
    }

    private static void checkForHelp(String[] args) {
        for (String arg : args) {
            if (!"-?".equals(arg) && !"-h".equals(arg) && !"-help".equals(arg)) continue;
            System.out.println("\"Usage: [-Daeron.dir=<directory containing CnC file>] DriverTool <pid>");
            System.out.println("  pid: prints PID of driver only.");
            System.exit(0);
        }
    }
}

