/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import java.io.File;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;

public class AeronStat {
    private static final String ANSI_CLS = "\u001b[2J";
    private static final String ANSI_HOME = "\u001b[H";
    private static final String DELAY = "delay";
    private static final String COUNTER_TYPE_ID = "type";
    private static final String COUNTER_IDENTITY = "identity";
    private static final String COUNTER_SESSION_ID = "session";
    private static final String COUNTER_STREAM_ID = "stream";
    private static final String COUNTER_CHANNEL = "channel";
    private final CountersReader counters;
    private final Pattern typeFilter;
    private final Pattern identityFilter;
    private final Pattern sessionFilter;
    private final Pattern streamFilter;
    private final Pattern channelFilter;

    public AeronStat(CountersReader counters, Pattern typeFilter, Pattern identityFilter, Pattern sessionFilter, Pattern streamFilter, Pattern channelFilter) {
        this.counters = counters;
        this.typeFilter = typeFilter;
        this.identityFilter = identityFilter;
        this.sessionFilter = sessionFilter;
        this.streamFilter = streamFilter;
        this.channelFilter = channelFilter;
    }

    public AeronStat(CountersReader counters) {
        this.counters = counters;
        this.typeFilter = null;
        this.identityFilter = null;
        this.sessionFilter = null;
        this.streamFilter = null;
        this.channelFilter = null;
    }

    public static CountersReader mapCounters() {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "cnc");
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (15 != cncVersion) {
            throw new IllegalStateException("Aeron CnC version does not match: version=" + cncVersion + " required=" + 15);
        }
        return new CountersReader(CncFileDescriptor.createCountersMetaDataBuffer(cncByteBuffer, cncMetaData), CncFileDescriptor.createCountersValuesBuffer(cncByteBuffer, cncMetaData), StandardCharsets.US_ASCII);
    }

    public static void main(String[] args) throws Exception {
        long delayMs = 1000L;
        Pattern typeFilter = null;
        Pattern identityFilter = null;
        Pattern sessionFilter = null;
        Pattern streamFilter = null;
        Pattern channelFilter = null;
        if (0 != args.length) {
            AeronStat.checkForHelp(args);
            block16: for (String arg : args) {
                int equalsIndex = arg.indexOf(61);
                if (-1 == equalsIndex) {
                    System.out.println("Arguments must be in name=pattern format: Invalid '" + arg + "'");
                    return;
                }
                String argName = arg.substring(0, equalsIndex);
                String argValue = arg.substring(equalsIndex + 1);
                switch (argName) {
                    case "delay": {
                        delayMs = Long.parseLong(argValue) * 1000L;
                        continue block16;
                    }
                    case "type": {
                        typeFilter = Pattern.compile(argValue);
                        continue block16;
                    }
                    case "identity": {
                        identityFilter = Pattern.compile(argValue);
                        continue block16;
                    }
                    case "session": {
                        sessionFilter = Pattern.compile(argValue);
                        continue block16;
                    }
                    case "stream": {
                        streamFilter = Pattern.compile(argValue);
                        continue block16;
                    }
                    case "channel": {
                        channelFilter = Pattern.compile(argValue);
                        continue block16;
                    }
                    default: {
                        System.out.println("Unrecognised argument: '" + arg + "'");
                        return;
                    }
                }
            }
        }
        AeronStat aeronStat = new AeronStat(AeronStat.mapCounters(), typeFilter, identityFilter, sessionFilter, streamFilter, channelFilter);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        String header = " - Aeron Stat (CnC v15), pid " + SystemUtil.getPid();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        while (running.get()) {
            AeronStat.clearScreen();
            System.out.print(dateFormat.format(new Date()));
            System.out.println(header);
            System.out.println("======================================================================");
            aeronStat.print(System.out);
            System.out.println("--");
            Thread.sleep(delayMs);
        }
    }

    public void print(PrintStream out) {
        this.counters.forEach((counterId, typeId, keyBuffer, label) -> {
            if (this.filter(typeId, keyBuffer)) {
                long value = this.counters.getCounterValue(counterId);
                out.format("%3d: %,20d - %s%n", counterId, value, label);
            }
        });
    }

    private static void checkForHelp(String[] args) {
        for (String arg : args) {
            if (!"-?".equals(arg) && !"-h".equals(arg) && !"-help".equals(arg)) continue;
            System.out.format("Usage: [-Daeron.dir=<directory containing CnC file>] AeronStat%n\t[delay=<seconds between updates>]%nfilter by optional regex patterns:%n\t[type=<pattern>]%n\t[identity=<pattern>]%n\t[sessionId=<pattern>]%n\t[streamId=<pattern>]%n\t[channel=<pattern>]%n", new Object[0]);
            System.exit(0);
        }
    }

    private boolean filter(int typeId, DirectBuffer keyBuffer) {
        if (!AeronStat.match(this.typeFilter, () -> Integer.toString(typeId))) {
            return false;
        }
        if (0 == typeId && !AeronStat.match(this.identityFilter, () -> Integer.toString(keyBuffer.getInt(0)))) {
            return false;
        }
        if (typeId >= 1 && typeId <= 5 || typeId == 9 || typeId == 10 || typeId == 12) {
            return AeronStat.match(this.identityFilter, () -> Long.toString(keyBuffer.getLong(0))) && AeronStat.match(this.sessionFilter, () -> Integer.toString(keyBuffer.getInt(8))) && AeronStat.match(this.streamFilter, () -> Integer.toString(keyBuffer.getInt(12))) && AeronStat.match(this.channelFilter, () -> keyBuffer.getStringAscii(16));
        }
        if (typeId >= 6 && typeId <= 7) {
            return AeronStat.match(this.channelFilter, () -> keyBuffer.getStringAscii(0));
        }
        return true;
    }

    private static boolean match(Pattern pattern, Supplier<String> supplier) {
        return null == pattern || pattern.matcher(supplier.get()).find();
    }

    private static void clearScreen() throws Exception {
        if (SystemUtil.osName().contains("win")) {
            new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
        } else {
            System.out.print("\u001b[2J\u001b[H");
        }
    }
}

