/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class NakFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 28;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int TERM_ID_FIELD_OFFSET = 16;
    private static final int TERM_OFFSET_FIELD_OFFSET = 20;
    private static final int LENGTH_FIELD_OFFSET = 24;

    public NakFlyweight() {
    }

    public NakFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public NakFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight sessionId(int sessionId) {
        this.putInt(8, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight streamId(int streamId) {
        this.putInt(12, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight termId(int termId) {
        this.putInt(16, termId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termOffset() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight termOffset(int termOffset) {
        this.putInt(20, termOffset, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int length() {
        return this.getInt(24, ByteOrder.LITTLE_ENDIAN);
    }

    public NakFlyweight length(int length) {
        this.putInt(24, length, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String formattedFlags = String.format("%1$8s", Integer.toBinaryString(this.flags())).replace(' ', '0');
        sb.append("NAK Message{").append("frame_length=").append(this.frameLength()).append(" version=").append(this.version()).append(" flags=").append(formattedFlags).append(" type=").append(this.headerType()).append(" term_offset=").append(this.termOffset()).append(" session_id=").append(this.sessionId()).append(" stream_id=").append(this.streamId()).append(" term_id=").append(this.termId()).append(" length=").append(this.length()).append("}");
        return sb.toString();
    }
}

