/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.DynamicMultiDestination;
import io.aeron.driver.media.ManualMultiDestination;
import io.aeron.driver.media.MultiDestination;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import io.aeron.status.ChannelEndpointStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class SendChannelEndpoint
extends UdpChannelTransport {
    private static final long DESTINATION_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private int refCount = 0;
    private final BiInt2ObjectMap<NetworkPublication> publicationBySessionAndStreamId = new BiInt2ObjectMap();
    private final MultiDestination multiDestination;
    private final AtomicCounter statusMessagesReceived;
    private final AtomicCounter nakMessagesReceived;
    private final AtomicCounter statusIndicator;

    public SendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteControl(), udpChannel.localControl(), !udpChannel.hasExplicitControl() ? udpChannel.remoteData() : null, context.errorLog(), context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS));
        this.nakMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGES_RECEIVED);
        this.statusMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGES_RECEIVED);
        this.statusIndicator = statusIndicator;
        MultiDestination multiDestination = null;
        if (udpChannel.hasExplicitControl()) {
            String mode = udpChannel.channelUri().get("control-mode");
            if ("manual".equals(mode)) {
                multiDestination = new ManualMultiDestination();
            } else if (null == mode || "dynamic".equals(mode)) {
                multiDestination = new DynamicMultiDestination(context.cachedNanoClock(), DESTINATION_TIMEOUT);
            }
        }
        this.multiDestination = multiDestination;
    }

    public void decRef() {
        --this.refCount;
    }

    public void incRef() {
        ++this.refCount;
    }

    public void openChannel(DriverConductorProxy conductorProxy) {
        if (conductorProxy.notConcurrent()) {
            this.openDatagramChannel(this.statusIndicator);
        } else {
            try {
                this.openDatagramChannel(this.statusIndicator);
            }
            catch (Exception ex) {
                conductorProxy.channelEndpointError(this.statusIndicator.id(), ex);
                throw ex;
            }
        }
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    public int statusIndicatorCounterId() {
        return this.statusIndicator.id();
    }

    public void indicateActive() {
        long currentStatus = this.statusIndicator.get();
        if (currentStatus != 0L) {
            throw new IllegalStateException("channel cannot be registered unless INITALIZING: status=" + ChannelEndpointStatus.status(currentStatus));
        }
        this.statusIndicator.setOrdered(1L);
    }

    public void closeStatusIndicator() {
        if (!this.statusIndicator.isClosed()) {
            this.statusIndicator.setOrdered(2L);
            this.statusIndicator.close();
        }
    }

    public boolean shouldBeClosed() {
        return 0 == this.refCount && !this.statusIndicator.isClosed();
    }

    public void registerForSend(NetworkPublication publication) {
        this.publicationBySessionAndStreamId.put(publication.sessionId(), publication.streamId(), publication);
    }

    public void unregisterForSend(NetworkPublication publication) {
        this.publicationBySessionAndStreamId.remove(publication.sessionId(), publication.streamId());
    }

    public int send(ByteBuffer buffer) {
        int bytesSent = 0;
        if (null != this.sendDatagramChannel) {
            int bytesToSend = buffer.remaining();
            if (null == this.multiDestination) {
                try {
                    this.sendHook(buffer, this.connectAddress);
                    if (this.sendDatagramChannel.isConnected()) {
                        bytesSent = this.sendDatagramChannel.write(buffer);
                    }
                }
                catch (PortUnreachableException portUnreachableException) {
                }
                catch (IOException ex) {
                    SendChannelEndpoint.sendError(bytesToSend, ex, this.connectAddress);
                }
            } else {
                bytesSent = this.multiDestination.send(this.sendDatagramChannel, buffer, this, bytesToSend);
            }
        }
        return bytesSent;
    }

    public void onStatusMessage(StatusMessageFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        int sessionId = msg.sessionId();
        int streamId = msg.streamId();
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(sessionId, streamId);
        if (null != this.multiDestination) {
            this.multiDestination.onStatusMessage(msg, srcAddress);
            if (0 == sessionId && 0 == streamId && 128 == (msg.flags() & 0x80)) {
                this.publicationBySessionAndStreamId.forEach(NetworkPublication::triggerSendSetupFrame);
                this.statusMessagesReceived.incrementOrdered();
            }
        }
        if (null != publication) {
            if (128 == (msg.flags() & 0x80)) {
                publication.triggerSendSetupFrame();
            } else {
                publication.onStatusMessage(msg, srcAddress);
            }
            this.statusMessagesReceived.incrementOrdered();
        }
    }

    public void onNakMessage(NakFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(msg.sessionId(), msg.streamId());
        if (null != publication) {
            publication.onNak(msg.termId(), msg.termOffset(), msg.length());
            this.nakMessagesReceived.incrementOrdered();
        }
    }

    public void onRttMeasurement(RttMeasurementFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(msg.sessionId(), msg.streamId());
        if (null != publication) {
            publication.onRttMeasurement(msg, srcAddress);
        }
    }

    public void validateAllowsManualControl() {
        if (null == this.multiDestination || !this.multiDestination.isManualControlMode()) {
            throw new IllegalArgumentException("control channel does not allow manual control");
        }
    }

    public void addDestination(InetSocketAddress address) {
        this.multiDestination.addDestination(address);
    }

    public void removeDestination(InetSocketAddress address) {
        this.multiDestination.removeDestination(address);
    }
}

