/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.MultiDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.NanoClock;

class DynamicMultiDestination
extends MultiDestination {
    private final long destinationTimeoutNs;
    private final NanoClock nanoClock;
    private final ArrayList<Destination> destinations = new ArrayList();

    DynamicMultiDestination(NanoClock nanoClock, long timeout) {
        this.nanoClock = nanoClock;
        this.destinationTimeoutNs = timeout;
    }

    @Override
    boolean isManualControlMode() {
        return false;
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
        long nowNs = this.nanoClock.nanoTime();
        ArrayList<Destination> destinations = this.destinations;
        boolean isExisting = false;
        long receiverId = msg.receiverId();
        int size = destinations.size();
        for (int i = 0; i < size; ++i) {
            Destination destination = destinations.get(i);
            if (receiverId != destination.receiverId || address.getPort() != destination.port) continue;
            destination.timeOfLastActivityNs = nowNs;
            isExisting = true;
            break;
        }
        if (!isExisting) {
            destinations.add(new Destination(nowNs, receiverId, address));
        }
    }

    @Override
    int send(DatagramChannel datagramChannel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend) {
        int lastIndex;
        long nowNs = this.nanoClock.nanoTime();
        ArrayList<Destination> destinations = this.destinations;
        int position = buffer.position();
        int minBytesSent = bytesToSend;
        for (int i = lastIndex = destinations.size() - 1; i >= 0; --i) {
            Destination destination = destinations.get(i);
            if (destination.timeOfLastActivityNs + this.destinationTimeoutNs - nowNs < 0L) {
                ArrayListUtil.fastUnorderedRemove(destinations, i, lastIndex--);
                continue;
            }
            minBytesSent = Math.min(minBytesSent, DynamicMultiDestination.send(datagramChannel, buffer, channelEndpoint, bytesToSend, position, destination.address));
        }
        return minBytesSent;
    }

    @Override
    void addDestination(InetSocketAddress address) {
    }

    @Override
    void removeDestination(InetSocketAddress address) {
    }

    static final class Destination {
        long timeOfLastActivityNs;
        final long receiverId;
        final int port;
        final InetSocketAddress address;

        Destination(long now, long receiverId, InetSocketAddress address) {
            this.timeOfLastActivityNs = now;
            this.receiverId = receiverId;
            this.address = address;
            this.port = address.getPort();
        }
    }
}

