/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.RawLog;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BitUtil;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;

class MappedRawLog
implements RawLog {
    private static final int ONE_GIG = 0x40000000;
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
    private static final EnumSet<StandardOpenOption> SPARSE_FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];
    private final int termLength;
    private final UnsafeBuffer[] termBuffers = new UnsafeBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final ErrorHandler errorHandler;
    private File logFile;
    private MappedByteBuffer[] mappedBuffers;

    MappedRawLog(File location, boolean useSparseFiles, int termLength, int filePageSize, ErrorHandler errorHandler) {
        this.termLength = termLength;
        this.errorHandler = errorHandler;
        this.logFile = location;
        EnumSet<StandardOpenOption> options = useSparseFiles ? SPARSE_FILE_OPTIONS : FILE_OPTIONS;
        try (FileChannel logChannel = FileChannel.open(this.logFile.toPath(), options, NO_ATTRIBUTES);){
            long logLength = LogBufferDescriptor.computeLogLength(termLength, filePageSize);
            if (logLength <= Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (!useSparseFiles) {
                    MappedRawLog.allocatePages(mappedBuffer, (int)logLength, filePageSize);
                }
                this.mappedBuffers = new MappedByteBuffer[]{mappedBuffer};
                for (int i = 0; i < 3; ++i) {
                    this.termBuffers[i] = new UnsafeBuffer(mappedBuffer, i * termLength, termLength);
                }
                this.logMetaDataBuffer = new UnsafeBuffer(mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
            } else {
                this.mappedBuffers = new MappedByteBuffer[4];
                for (int i = 0; i < 3; ++i) {
                    MappedByteBuffer buffer = logChannel.map(FileChannel.MapMode.READ_WRITE, (long)termLength * (long)i, termLength);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.mappedBuffers[i] = buffer;
                    if (!useSparseFiles) {
                        MappedRawLog.allocatePages(buffer, termLength, filePageSize);
                    }
                    this.termBuffers[i] = new UnsafeBuffer(buffer, 0, termLength);
                }
                int metaDataMappingLength = BitUtil.align(LogBufferDescriptor.LOG_META_DATA_LENGTH, filePageSize);
                long metaDataSectionOffset = (long)termLength * 3L;
                MappedByteBuffer metaDataMappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, metaDataSectionOffset, metaDataMappingLength);
                metaDataMappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedBuffers[3] = metaDataMappedBuffer;
                this.logMetaDataBuffer = new UnsafeBuffer(metaDataMappedBuffer, metaDataMappingLength - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int termLength() {
        return this.termLength;
    }

    @Override
    public boolean isInactive() {
        return null == this.mappedBuffers;
    }

    @Override
    public boolean free() {
        if (null != this.mappedBuffers) {
            for (MappedByteBuffer buffer : this.mappedBuffers) {
                IoUtil.unmap(buffer);
            }
            this.mappedBuffers = null;
        }
        if (null != this.logFile) {
            if (!this.logFile.delete()) {
                return false;
            }
            this.logFile = null;
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.free()) {
            this.errorHandler.onError(new AeronException("unable to delete " + this.logFile));
        }
    }

    @Override
    public UnsafeBuffer[] termBuffers() {
        return this.termBuffers;
    }

    @Override
    public UnsafeBuffer metaData() {
        return this.logMetaDataBuffer;
    }

    @Override
    public ByteBuffer[] sliceTerms() {
        ByteBuffer[] terms = new ByteBuffer[3];
        if (this.termLength < 0x40000000) {
            MappedByteBuffer buffer = this.mappedBuffers[0];
            for (int i = 0; i < 3; ++i) {
                buffer.limit(this.termLength * i + this.termLength).position(this.termLength * i);
                terms[i] = buffer.slice();
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                terms[i] = this.mappedBuffers[i].duplicate();
            }
        }
        return terms;
    }

    @Override
    public String fileName() {
        return this.logFile.getAbsolutePath();
    }

    private static void allocatePages(MappedByteBuffer buffer, int length, int pageSize) {
        for (int i = 0; i < length; i += pageSize) {
            buffer.put(i, (byte)0);
        }
    }
}

