/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Publication;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.SnapshotMark;
import io.aeron.cluster.codecs.SnapshotMarkerEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.IdleStrategy;

public class SnapshotTaker {
    protected static final int ENCODED_MARKER_LENGTH = 40;
    protected final BufferClaim bufferClaim = new BufferClaim();
    protected final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    protected final Publication publication;
    protected final IdleStrategy idleStrategy;
    protected final AgentInvoker aeronClientInvoker;
    private final SnapshotMarkerEncoder snapshotMarkerEncoder = new SnapshotMarkerEncoder();

    public SnapshotTaker(Publication publication, IdleStrategy idleStrategy, AgentInvoker aeronClientInvoker) {
        this.publication = publication;
        this.idleStrategy = idleStrategy;
        this.aeronClientInvoker = aeronClientInvoker;
    }

    public void markBegin(long snapshotTypeId, long logPosition, long leadershipTermId, int snapshotIndex) {
        this.markSnapshot(snapshotTypeId, logPosition, leadershipTermId, snapshotIndex, SnapshotMark.BEGIN);
    }

    public void markEnd(long snapshotTypeId, long logPosition, long leadershipTermId, int snapshotIndex) {
        this.markSnapshot(snapshotTypeId, logPosition, leadershipTermId, snapshotIndex, SnapshotMark.END);
    }

    public void markSnapshot(long snapshotTypeId, long logPosition, long leadershipTermId, int snapshotIndex, SnapshotMark snapshotMark) {
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(40, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.snapshotMarkerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).typeId(snapshotTypeId).logPosition(logPosition).leadershipTermId(leadershipTermId).index(snapshotIndex).mark(snapshotMark);
        this.bufferClaim.commit();
    }

    protected static void checkInterruptedStatus() {
        if (Thread.currentThread().isInterrupted()) {
            throw new AgentTerminationException("unexpected interrupt during operation");
        }
    }

    protected static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new AeronException("unexpected publication state: " + result);
        }
    }

    protected void checkResultAndIdle(long result) {
        SnapshotTaker.checkResult(result);
        SnapshotTaker.checkInterruptedStatus();
        this.invokeAeronClient();
        this.idleStrategy.idle();
    }

    protected void invokeAeronClient() {
        if (null != this.aeronClientInvoker) {
            this.aeronClientInvoker.invoke();
        }
    }
}

