/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.Counter;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public class ServiceHeartbeat {
    public static final int SERVICE_HEARTBEAT_TYPE_ID = 206;
    public static final int SERVICE_ID_OFFSET = 0;
    public static final String NAME = "service-heartbeat: serviceId=";
    public static final int KEY_LENGTH = 4;

    public static Counter allocate(Aeron aeron, MutableDirectBuffer tempBuffer, int serviceId) {
        tempBuffer.putInt(0, serviceId);
        int labelOffset = BitUtil.align(4, 4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, NAME);
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, serviceId);
        return aeron.addCounter(206, tempBuffer, 0, 4, tempBuffer, labelOffset, labelLength);
    }

    public static int findCounterId(CountersReader counters, int serviceId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int recordOffset;
            if (counters.getCounterState(i) != 1 || buffer.getInt((recordOffset = CountersReader.metaDataOffset(i)) + 4) != 206 || buffer.getInt(recordOffset + 16 + 0) != serviceId) continue;
            return i;
        }
        return -1;
    }
}

