/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.cluster.client.ClusterException;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public class RecoveryState {
    public static final int RECOVERY_STATE_TYPE_ID = 204;
    public static final String NAME = "cluster recovery: leadershipTermId=";
    public static final int LEADERSHIP_TERM_ID_OFFSET = 0;
    public static final int LOG_POSITION_OFFSET = 8;
    public static final int TIMESTAMP_OFFSET = 16;
    public static final int REPLAY_FLAG_OFFSET = 24;
    public static final int SERVICE_COUNT_OFFSET = 28;
    public static final int SNAPSHOT_RECORDING_IDS_OFFSET = 32;

    public static Counter allocate(Aeron aeron, MutableDirectBuffer tempBuffer, long leadershipTermId, long logPosition, long timestamp, boolean hasReplay, long ... snapshotRecordingIds) {
        tempBuffer.putLong(0, leadershipTermId);
        tempBuffer.putLong(8, logPosition);
        tempBuffer.putLong(16, timestamp);
        tempBuffer.putInt(24, hasReplay ? 1 : 0);
        int serviceCount = snapshotRecordingIds.length;
        tempBuffer.putInt(28, serviceCount);
        int keyLength = 32 + serviceCount * 8;
        if (keyLength > 112) {
            throw new ClusterException(keyLength + " exceeds max key length " + 112);
        }
        for (int i = 0; i < serviceCount; ++i) {
            tempBuffer.putLong(32 + i * 8, snapshotRecordingIds[i]);
        }
        int labelOffset = BitUtil.align(keyLength, 4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, NAME);
        labelLength += tempBuffer.putLongAscii(keyLength + labelLength, leadershipTermId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " logPosition=");
        labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, logPosition);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " hasReplay=" + hasReplay);
        return aeron.addCounter(204, tempBuffer, 0, keyLength, tempBuffer, labelOffset, labelLength);
    }

    public static int findCounterId(CountersReader counters) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int recordOffset;
            if (counters.getCounterState(i) != 1 || buffer.getInt((recordOffset = CountersReader.metaDataOffset(i)) + 4) != 204) continue;
            return i;
        }
        return -1;
    }

    public static long getLeadershipTermId(CountersReader counters, int counterId) {
        int recordOffset;
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && buffer.getInt((recordOffset = CountersReader.metaDataOffset(counterId)) + 4) == 204) {
            return buffer.getLong(recordOffset + 16 + 0);
        }
        return -1L;
    }

    public static long getLogPosition(CountersReader counters, int counterId) {
        int recordOffset;
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && buffer.getInt((recordOffset = CountersReader.metaDataOffset(counterId)) + 4) == 204) {
            return buffer.getLong(recordOffset + 16 + 8);
        }
        return -1L;
    }

    public static long getTimestamp(CountersReader counters, int counterId) {
        int recordOffset;
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && buffer.getInt((recordOffset = CountersReader.metaDataOffset(counterId)) + 4) == 204) {
            return buffer.getLong(recordOffset + 16 + 16);
        }
        return -1L;
    }

    public static boolean hasReplay(CountersReader counters, int counterId) {
        int recordOffset;
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && buffer.getInt((recordOffset = CountersReader.metaDataOffset(counterId)) + 4) == 204) {
            return buffer.getInt(recordOffset + 16 + 24) == 1;
        }
        return false;
    }

    public static long getSnapshotRecordingId(CountersReader counters, int counterId, int serviceId) {
        int recordOffset;
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && buffer.getInt((recordOffset = CountersReader.metaDataOffset(counterId)) + 4) == 204) {
            int serviceCount = buffer.getInt(recordOffset + 16 + 28);
            if (serviceId < 0 || serviceId >= serviceCount) {
                throw new ClusterException("invalid serviceId " + serviceId + " for count of " + serviceCount);
            }
            return buffer.getLong(recordOffset + 16 + 32 + serviceId * 8);
        }
        throw new ClusterException("Active counter not found " + counterId);
    }
}

