/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CancelTimerEncoder;
import io.aeron.cluster.codecs.CloseSessionEncoder;
import io.aeron.cluster.codecs.ClusterMembersQueryEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.RemoveMemberEncoder;
import io.aeron.cluster.codecs.ScheduleTimerEncoder;
import io.aeron.cluster.codecs.ServiceAckEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;

public final class ConsensusModuleProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 3;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ScheduleTimerEncoder scheduleTimerEncoder = new ScheduleTimerEncoder();
    private final CancelTimerEncoder cancelTimerEncoder = new CancelTimerEncoder();
    private final ServiceAckEncoder serviceAckEncoder = new ServiceAckEncoder();
    private final CloseSessionEncoder closeSessionEncoder = new CloseSessionEncoder();
    private final ClusterMembersQueryEncoder clusterMembersQueryEncoder = new ClusterMembersQueryEncoder();
    private final RemoveMemberEncoder removeMemberEncoder = new RemoveMemberEncoder();
    private final Publication publication;

    public ConsensusModuleProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close(this.publication);
    }

    public boolean isConnected() {
        return this.publication.isConnected();
    }

    public boolean scheduleTimer(long correlationId, long deadlineMs) {
        int length = 24;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) {
                this.scheduleTimerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).deadline(deadlineMs);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    public boolean cancelTimer(long correlationId) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.cancelTimerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    public void ack(long logPosition, long ackId, int serviceId) {
        this.ack(logPosition, ackId, -1L, serviceId);
    }

    public void ack(long logPosition, long ackId, long relevantId, int serviceId) {
        int length = 36;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(36, this.bufferClaim)) > 0L) {
                this.serviceAckEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition).ackId(ackId).relevantId(relevantId).serviceId(serviceId);
                this.bufferClaim.commit();
                return;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        throw new ClusterException("failed to send ACK");
    }

    public boolean closeSession(long clusterSessionId) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.closeSessionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(clusterSessionId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    public boolean clusterMembersQuery(long correlationId) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.clusterMembersQueryEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    public boolean removeMember(long correlationId, int memberId, BooleanType isPassive) {
        int length = 24;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(24, this.bufferClaim)) > 0L) {
                this.removeMemberEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).memberId(memberId).isPassive(isPassive);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusModuleProxy.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(long result) {
        if (result == -1L || result == -4L || result == -5L) {
            throw new AeronException("unexpected publication state: " + result);
        }
    }
}

