/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.cluster.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.cluster.codecs.mark.VarAsciiEncodingEncoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.MarkFile;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;

public class ClusterMarkFile
implements AutoCloseable {
    public static final String FILE_EXTENSION = ".dat";
    public static final String FILENAME = "cluster-mark.dat";
    public static final String SERVICE_FILENAME_PREFIX = "cluster-mark-service-";
    public static final String SERVICE_FILENAME_FORMAT = "cluster-mark-service-%d.dat";
    public static final int HEADER_LENGTH = 8192;
    public static final int VERSION_READY = 0;
    public static final int VERSION_FAILED = -1;
    private final MarkFileHeaderDecoder headerDecoder = new MarkFileHeaderDecoder();
    private final MarkFileHeaderEncoder headerEncoder = new MarkFileHeaderEncoder();
    private final MarkFile markFile;
    private final UnsafeBuffer buffer;
    private final UnsafeBuffer errorBuffer;

    public ClusterMarkFile(File file, ClusterComponentType type, int errorBufferLength, EpochClock epochClock, long timeoutMs) {
        boolean markFileExists = file.exists();
        this.markFile = new MarkFile(file, markFileExists, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), 8192 + errorBufferLength, timeoutMs, epochClock, version -> {
            if (version != 0) {
                if (-1 == version && markFileExists) {
                    System.err.println("mark file version -1 indicates error on previous startup.");
                } else {
                    throw new ClusterException("mark file version " + version + " does not match software:" + 0);
                }
            }
        }, null);
        this.buffer = this.markFile.buffer();
        this.errorBuffer = new UnsafeBuffer(this.buffer, 8192, errorBufferLength);
        this.headerEncoder.wrap(this.buffer, 0);
        this.headerDecoder.wrap(this.buffer, 0, 128, 0);
        if (markFileExists) {
            UnsafeBuffer existingErrorBuffer = new UnsafeBuffer(this.buffer, this.headerDecoder.headerLength(), this.headerDecoder.errorBufferLength());
            ClusterMarkFile.saveExistingErrors(file, existingErrorBuffer, System.err);
            this.errorBuffer.setMemory(0, errorBufferLength, (byte)0);
        } else {
            this.headerEncoder.candidateTermId(-1L);
        }
        ClusterComponentType existingType = this.headerDecoder.componentType();
        if (existingType != ClusterComponentType.NULL && existingType != type) {
            throw new IllegalStateException("existing Mark file type " + (Object)((Object)existingType) + " not same as required type " + (Object)((Object)type));
        }
        this.headerEncoder.componentType(type);
        this.headerEncoder.headerLength(8192);
        this.headerEncoder.errorBufferLength(errorBufferLength);
        this.headerEncoder.pid(SystemUtil.getPid());
        this.headerEncoder.startTimestamp(epochClock.time());
    }

    public ClusterMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        this.markFile = new MarkFile(directory, filename, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), timeoutMs, epochClock, version -> {
            if (version != 0) {
                throw new IllegalArgumentException("mark file version " + version + " does not match software:" + 0);
            }
        }, logger);
        this.buffer = this.markFile.buffer();
        this.headerDecoder.wrap(this.buffer, 0, 128, 0);
        this.errorBuffer = new UnsafeBuffer(this.buffer, this.headerDecoder.headerLength(), this.headerDecoder.errorBufferLength());
    }

    @Override
    public void close() {
        CloseHelper.close(this.markFile);
    }

    public long candidateTermId() {
        return this.buffer.getLongVolatile(MarkFileHeaderDecoder.candidateTermIdEncodingOffset());
    }

    public void candidateTermId(long candidateTermId) {
        this.buffer.putLongVolatile(MarkFileHeaderEncoder.candidateTermIdEncodingOffset(), candidateTermId);
        this.markFile.mappedByteBuffer().force();
    }

    public int memberId() {
        return this.buffer.getIntVolatile(MarkFileHeaderDecoder.memberIdEncodingOffset());
    }

    public void memberId(int memberId) {
        this.buffer.putIntVolatile(MarkFileHeaderEncoder.memberIdEncodingOffset(), memberId);
        this.markFile.mappedByteBuffer().force();
    }

    public void signalReady() {
        this.markFile.signalReady(0);
        this.markFile.mappedByteBuffer().force();
    }

    public void signalFailedStart() {
        this.markFile.signalReady(-1);
        this.markFile.mappedByteBuffer().force();
    }

    public void updateActivityTimestamp(long nowMs) {
        this.markFile.timestampOrdered(nowMs);
    }

    public long activityTimestampVolatile() {
        return this.markFile.timestampVolatile();
    }

    public MarkFileHeaderEncoder encoder() {
        return this.headerEncoder;
    }

    public MarkFileHeaderDecoder decoder() {
        return this.headerDecoder;
    }

    public UnsafeBuffer buffer() {
        return this.buffer;
    }

    public UnsafeBuffer errorBuffer() {
        return this.errorBuffer;
    }

    public static void saveExistingErrors(File markFile, AtomicBuffer errorBuffer, PrintStream logger) {
        block15: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int observations = ClusterMarkFile.saveErrorLog(new PrintStream((OutputStream)baos, false, "UTF-8"), errorBuffer);
                if (observations <= 0) break block15;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSSZ");
                String errorLogFilename = markFile.getParent() + '-' + dateFormat.format(new Date()) + "-error.log";
                if (null != logger) {
                    logger.println("WARNING: Existing errors saved to: " + errorLogFilename);
                }
                try (FileOutputStream out = new FileOutputStream(errorLogFilename);){
                    baos.writeTo(out);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        }
    }

    public static int saveErrorLog(PrintStream out, AtomicBuffer errorBuffer) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        ErrorConsumer errorConsumer = (count, firstTimestamp, lastTimestamp, ex) -> out.format("***%n%d observations from %s to %s for:%n %s%n", count, dateFormat.format(new Date(firstTimestamp)), dateFormat.format(new Date(lastTimestamp)), ex);
        int distinctErrorCount = ErrorLogReader.read(errorBuffer, errorConsumer);
        out.format("%n%d distinct errors observed.%n", distinctErrorCount);
        return distinctErrorCount;
    }

    public static void checkHeaderLength(String aeronDirectory, String archiveChannel, String serviceControlChannel, String ingressChannel, String serviceName, String authenticator) {
        Objects.requireNonNull(aeronDirectory);
        Objects.requireNonNull(archiveChannel);
        Objects.requireNonNull(serviceControlChannel);
        int lengthRequired = 128 + 6 * VarAsciiEncodingEncoder.lengthEncodingLength() + aeronDirectory.length() + archiveChannel.length() + serviceControlChannel.length() + (null == ingressChannel ? 0 : ingressChannel.length()) + (null == serviceName ? 0 : serviceName.length()) + (null == authenticator ? 0 : authenticator.length());
        if (lengthRequired > 8192) {
            throw new ClusterException("MarkFile length required " + lengthRequired + " greater than " + 8192);
        }
    }

    public static String markFilenameForService(int serviceId) {
        return String.format(SERVICE_FILENAME_FORMAT, serviceId);
    }
}

