/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.ClusteredServiceContainer;
import java.util.Collection;

public interface Cluster {
    public int memberId();

    public Role role();

    public Aeron aeron();

    public ClusteredServiceContainer.Context context();

    public ClientSession getClientSession(long var1);

    public Collection<ClientSession> clientSessions();

    public boolean closeSession(long var1);

    public long timeMs();

    public boolean scheduleTimer(long var1, long var3);

    public boolean cancelTimer(long var1);

    public void idle();

    public void idle(int var1);

    public static enum Role {
        FOLLOWER(0),
        CANDIDATE(1),
        LEADER(2);

        static final Role[] ROLES;
        private final int code;

        private Role(int code) {
            this.code = code;
        }

        public final int code() {
            return this.code;
        }

        public static Role get(int code) {
            if (code < 0 || code > ROLES.length - 1) {
                throw new IllegalStateException("Invalid role counter code: " + code);
            }
            return ROLES[code];
        }

        static {
            Role[] roles = Role.values();
            ROLES = new Role[roles.length];
            for (Role role : roles) {
                int code = role.code();
                if (null != ROLES[code]) {
                    throw new ClusterException("code already in use: " + code);
                }
                Role.ROLES[code] = role;
            }
        }
    }
}

