/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.DirectBufferVector;
import io.aeron.Publication;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.exceptions.RegistrationException;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

public class ClientSession {
    public static final long MOCKED_OFFER = 1L;
    private final long id;
    private final int responseStreamId;
    private final String responseChannel;
    private final byte[] encodedPrincipal;
    private final ClusteredServiceAgent cluster;
    private Publication responsePublication;
    private boolean isClosing;

    ClientSession(long sessionId, int responseStreamId, String responseChannel, byte[] encodedPrincipal, ClusteredServiceAgent cluster) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.encodedPrincipal = encodedPrincipal;
        this.cluster = cluster;
    }

    public long id() {
        return this.id;
    }

    public int responseStreamId() {
        return this.responseStreamId;
    }

    public String responseChannel() {
        return this.responseChannel;
    }

    public byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    public void close() {
        if (null != this.cluster.getClientSession(this.id)) {
            this.cluster.closeSession(this.id);
        }
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.cluster.offer(this.id, this.responsePublication, buffer, offset, length);
    }

    public long offer(DirectBufferVector[] vectors) {
        return this.cluster.offer(this.id, this.responsePublication, vectors);
    }

    void connect(Aeron aeron) {
        if (null == this.responsePublication) {
            try {
                this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
            }
            catch (RegistrationException ex) {
                this.cluster.handleError(ex);
            }
        }
    }

    void markClosing() {
        this.isClosing = true;
    }

    void resetClosing() {
        this.isClosing = false;
    }

    void disconnect() {
        CloseHelper.close(this.responsePublication);
        this.responsePublication = null;
    }
}

