/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterActionRequestDecoder;
import io.aeron.cluster.codecs.MembershipChangeEventDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import io.aeron.cluster.codecs.SessionCloseEventDecoder;
import io.aeron.cluster.codecs.SessionHeaderDecoder;
import io.aeron.cluster.codecs.SessionOpenEventDecoder;
import io.aeron.cluster.codecs.TimerEventDecoder;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.status.ReadableCounter;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

final class BoundedLogAdapter
implements ControlledFragmentHandler,
AutoCloseable {
    private static final int FRAGMENT_LIMIT = 100;
    private static final int INITIAL_BUFFER_LENGTH = 4096;
    private static final int SESSION_HEADER_LENGTH = 32;
    private final ImageControlledFragmentAssembler fragmentAssembler = new ImageControlledFragmentAssembler(this, 4096, true);
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionOpenEventDecoder openEventDecoder = new SessionOpenEventDecoder();
    private final SessionCloseEventDecoder closeEventDecoder = new SessionCloseEventDecoder();
    private final SessionHeaderDecoder sessionHeaderDecoder = new SessionHeaderDecoder();
    private final TimerEventDecoder timerEventDecoder = new TimerEventDecoder();
    private final ClusterActionRequestDecoder actionRequestDecoder = new ClusterActionRequestDecoder();
    private final NewLeadershipTermEventDecoder newLeadershipTermEventDecoder = new NewLeadershipTermEventDecoder();
    private final MembershipChangeEventDecoder membershipChangeEventDecoder = new MembershipChangeEventDecoder();
    private final Image image;
    private final ReadableCounter upperBound;
    private final ClusteredServiceAgent agent;

    BoundedLogAdapter(Image image, ReadableCounter upperBound, ClusteredServiceAgent agent) {
        this.image = image;
        this.upperBound = upperBound;
        this.agent = agent;
    }

    @Override
    public void close() {
        CloseHelper.close(this.image.subscription());
    }

    boolean isDone() {
        return this.image.isEndOfStream() || this.image.isClosed();
    }

    public long position() {
        return this.image.position();
    }

    public int poll() {
        return this.image.boundedControlledPoll(this.fragmentAssembler, this.upperBound.get(), 100);
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.sbeSchemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 20) {
            this.sessionHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.agent.onSessionMessage(this.sessionHeaderDecoder.clusterSessionId(), this.sessionHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        switch (templateId) {
            case 21: {
                this.timerEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onTimerEvent(this.timerEventDecoder.correlationId(), this.timerEventDecoder.timestamp());
                break;
            }
            case 22: {
                this.openEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.openEventDecoder.responseChannel();
                byte[] encodedPrincipal = new byte[this.openEventDecoder.encodedPrincipalLength()];
                this.openEventDecoder.getEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
                this.agent.onSessionOpen(this.openEventDecoder.clusterSessionId(), this.openEventDecoder.timestamp(), this.openEventDecoder.responseStreamId(), responseChannel, encodedPrincipal);
                break;
            }
            case 23: {
                this.closeEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onSessionClose(this.closeEventDecoder.clusterSessionId(), this.closeEventDecoder.timestamp(), this.closeEventDecoder.closeReason());
                break;
            }
            case 24: {
                this.actionRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onServiceAction(this.actionRequestDecoder.logPosition(), this.actionRequestDecoder.leadershipTermId(), this.actionRequestDecoder.timestamp(), this.actionRequestDecoder.action());
                break;
            }
            case 25: {
                this.newLeadershipTermEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onNewLeadershipTermEvent(this.newLeadershipTermEventDecoder.leadershipTermId(), this.newLeadershipTermEventDecoder.logPosition(), this.newLeadershipTermEventDecoder.timestamp(), this.newLeadershipTermEventDecoder.leaderMemberId(), this.newLeadershipTermEventDecoder.logSessionId());
                break;
            }
            case 26: {
                this.membershipChangeEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.agent.onMembershipChange(this.membershipChangeEventDecoder.leadershipTermId(), this.membershipChangeEventDecoder.logPosition(), this.membershipChangeEventDecoder.timestamp(), this.membershipChangeEventDecoder.leaderMemberId(), this.membershipChangeEventDecoder.clusterSize(), this.membershipChangeEventDecoder.changeType(), this.membershipChangeEventDecoder.memberId(), this.membershipChangeEventDecoder.clusterMembers());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

