/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.SnapshotRecordingsDecoder;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class SnapshotRecordingsEncoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 73;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotRecordingsEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    private final SnapshotsEncoder snapshots = new SnapshotsEncoder(this);

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 73;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotRecordingsEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public SnapshotRecordingsEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(73).schemaId(111).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public SnapshotRecordingsEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long snapshotsId() {
        return 3L;
    }

    public SnapshotsEncoder snapshotsCount(int count) {
        this.snapshots.wrap(this.buffer, count);
        return this.snapshots;
    }

    public static int memberEndpointsId() {
        return 10;
    }

    public static String memberEndpointsCharacterEncoding() {
        return "US-ASCII";
    }

    public static String memberEndpointsMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int memberEndpointsHeaderLength() {
        return 4;
    }

    public SnapshotRecordingsEncoder putMemberEndpoints(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotRecordingsEncoder putMemberEndpoints(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public SnapshotRecordingsEncoder memberEndpoints(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public SnapshotRecordingsEncoder memberEndpoints(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i) {
            char charValue = value.charAt(i);
            byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
            this.buffer.putByte(limit + 4 + i, byteValue);
        }
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        SnapshotRecordingsDecoder writer = new SnapshotRecordingsDecoder();
        writer.wrap(this.buffer, this.offset, 8, 0);
        return writer.appendTo(builder);
    }

    public static class SnapshotsEncoder {
        public static final int HEADER_SIZE = 4;
        private final SnapshotRecordingsEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;

        SnapshotsEncoder(SnapshotRecordingsEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = -1;
            this.count = count;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)44, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 44;
        }

        public SnapshotsEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SnapshotsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public static int recordingIdId() {
            return 4;
        }

        public static int recordingIdSinceVersion() {
            return 0;
        }

        public static int recordingIdEncodingOffset() {
            return 0;
        }

        public static int recordingIdEncodingLength() {
            return 8;
        }

        public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long recordingIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long recordingIdMinValue() {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder recordingId(long value) {
            this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int leadershipTermIdId() {
            return 5;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 8;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder leadershipTermId(long value) {
            this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int termBaseLogPositionId() {
            return 6;
        }

        public static int termBaseLogPositionSinceVersion() {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset() {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength() {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long termBaseLogPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long termBaseLogPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder termBaseLogPosition(long value) {
            this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int logPositionId() {
            return 7;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 24;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder logPosition(long value) {
            this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int timestampId() {
            return 8;
        }

        public static int timestampSinceVersion() {
            return 0;
        }

        public static int timestampEncodingOffset() {
            return 32;
        }

        public static int timestampEncodingLength() {
            return 8;
        }

        public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long timestampNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timestampMinValue() {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue() {
            return Long.MAX_VALUE;
        }

        public SnapshotsEncoder timestamp(long value) {
            this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int serviceIdId() {
            return 9;
        }

        public static int serviceIdSinceVersion() {
            return 0;
        }

        public static int serviceIdEncodingOffset() {
            return 40;
        }

        public static int serviceIdEncodingLength() {
            return 4;
        }

        public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static int serviceIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int serviceIdMinValue() {
            return -2147483647;
        }

        public static int serviceIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public SnapshotsEncoder serviceId(int value) {
            this.buffer.putInt(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }
    }
}

