/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.SnapshotMark;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public class SnapshotMarkerDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 100;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotMarkerDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 100;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotMarkerDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int typeIdId() {
        return 1;
    }

    public static int typeIdSinceVersion() {
        return 0;
    }

    public static int typeIdEncodingOffset() {
        return 0;
    }

    public static int typeIdEncodingLength() {
        return 8;
    }

    public static String typeIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long typeIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long typeIdMinValue() {
        return -9223372036854775807L;
    }

    public static long typeIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long typeId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leadershipTermIdId() {
        return 3;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long leadershipTermId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int indexId() {
        return 4;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 24;
    }

    public static int indexEncodingLength() {
        return 4;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int indexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int indexMinValue() {
        return -2147483647;
    }

    public static int indexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int index() {
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int markId() {
        return 5;
    }

    public static int markSinceVersion() {
        return 0;
    }

    public static int markEncodingOffset() {
        return 28;
    }

    public static int markEncodingLength() {
        return 4;
    }

    public static String markMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public SnapshotMark mark() {
        return SnapshotMark.get(this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN));
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[SnapshotMarker](sbeTemplateId=");
        builder.append(100);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("typeId=");
        builder.append(this.typeId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("index=");
        builder.append(this.index());
        builder.append('|');
        builder.append("mark=");
        builder.append((Object)this.mark());
        this.limit(originalLimit);
        return builder;
    }
}

