/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.ServiceAckDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class ServiceAckEncoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 33;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ServiceAckEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 33;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ServiceAckEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 28);
        return this;
    }

    public ServiceAckEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(33).schemaId(111).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int logPositionId() {
        return 1;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 0;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public ServiceAckEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int ackIdId() {
        return 2;
    }

    public static int ackIdSinceVersion() {
        return 0;
    }

    public static int ackIdEncodingOffset() {
        return 8;
    }

    public static int ackIdEncodingLength() {
        return 8;
    }

    public static String ackIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long ackIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long ackIdMinValue() {
        return -9223372036854775807L;
    }

    public static long ackIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ServiceAckEncoder ackId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int relevantIdId() {
        return 3;
    }

    public static int relevantIdSinceVersion() {
        return 0;
    }

    public static int relevantIdEncodingOffset() {
        return 16;
    }

    public static int relevantIdEncodingLength() {
        return 8;
    }

    public static String relevantIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long relevantIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long relevantIdMinValue() {
        return -9223372036854775807L;
    }

    public static long relevantIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ServiceAckEncoder relevantId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int serviceIdId() {
        return 4;
    }

    public static int serviceIdSinceVersion() {
        return 0;
    }

    public static int serviceIdEncodingOffset() {
        return 24;
    }

    public static int serviceIdEncodingLength() {
        return 4;
    }

    public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int serviceIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceIdMinValue() {
        return -2147483647;
    }

    public static int serviceIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ServiceAckEncoder serviceId(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        ServiceAckDecoder writer = new ServiceAckDecoder();
        writer.wrap(this.buffer, this.offset, 28, 0);
        return writer.appendTo(builder);
    }
}

