/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class NewLeadershipTermEventEncoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 25;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewLeadershipTermEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 25;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public NewLeadershipTermEventEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 32);
        return this;
    }

    public NewLeadershipTermEventEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(32).templateId(25).schemaId(111).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 3;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leaderMemberIdId() {
        return 4;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 24;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logSessionIdId() {
        return 5;
    }

    public static int logSessionIdSinceVersion() {
        return 0;
    }

    public static int logSessionIdEncodingOffset() {
        return 28;
    }

    public static int logSessionIdEncodingLength() {
        return 4;
    }

    public static String logSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int logSessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logSessionIdMinValue() {
        return -2147483647;
    }

    public static int logSessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder logSessionId(int value) {
        this.buffer.putInt(this.offset + 28, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        NewLeadershipTermEventDecoder writer = new NewLeadershipTermEventDecoder();
        writer.wrap(this.buffer, this.offset, 32, 0);
        return writer.appendTo(builder);
    }
}

