/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public class NewLeadershipTermDecoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewLeadershipTermDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 53;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public NewLeadershipTermDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int logLeadershipTermIdId() {
        return 1;
    }

    public static int logLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long logLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logLeadershipTermId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leadershipTermIdId() {
        return 3;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long leadershipTermId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int maxLogPositionId() {
        return 4;
    }

    public static int maxLogPositionSinceVersion() {
        return 0;
    }

    public static int maxLogPositionEncodingOffset() {
        return 24;
    }

    public static int maxLogPositionEncodingLength() {
        return 8;
    }

    public static String maxLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long maxLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long maxLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long maxLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long maxLogPosition() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leaderMemberIdId() {
        return 5;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 32;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int leaderMemberId() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logSessionIdId() {
        return 6;
    }

    public static int logSessionIdSinceVersion() {
        return 0;
    }

    public static int logSessionIdEncodingOffset() {
        return 36;
    }

    public static int logSessionIdEncodingLength() {
        return 4;
    }

    public static String logSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int logSessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logSessionIdMinValue() {
        return -2147483647;
    }

    public static int logSessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int logSessionId() {
        return this.buffer.getInt(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[NewLeadershipTerm](sbeTemplateId=");
        builder.append(53);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 40) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(40);
        builder.append("):");
        builder.append("logLeadershipTermId=");
        builder.append(this.logLeadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("maxLogPosition=");
        builder.append(this.maxLogPosition());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(this.leaderMemberId());
        builder.append('|');
        builder.append("logSessionId=");
        builder.append(this.logSessionId());
        this.limit(originalLimit);
        return builder;
    }
}

