/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MetaAttribute;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ClusterMembersDecoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 106;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ClusterMembersDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 106;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ClusterMembersDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int memberIdId() {
        return 1;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 0;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int memberId() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int highMemberIdId() {
        return 2;
    }

    public static int highMemberIdSinceVersion() {
        return 0;
    }

    public static int highMemberIdEncodingOffset() {
        return 4;
    }

    public static int highMemberIdEncodingLength() {
        return 4;
    }

    public static String highMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int highMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int highMemberIdMinValue() {
        return -2147483647;
    }

    public static int highMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int highMemberId() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int clusterMembersId() {
        return 3;
    }

    public static int clusterMembersSinceVersion() {
        return 0;
    }

    public static String clusterMembersCharacterEncoding() {
        return "US-ASCII";
    }

    public static String clusterMembersMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int clusterMembersHeaderLength() {
        return 4;
    }

    public int clusterMembersLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getClusterMembers(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getClusterMembers(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapClusterMembers(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String clusterMembers() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public void getClusterMembers(Appendable value) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        for (int i = 0; i < dataLength; ++i) {
            try {
                int c = this.buffer.getByte(dataOffset + i) & 0xFF;
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ClusterMembers](sbeTemplateId=");
        builder.append(106);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 8) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(8);
        builder.append("):");
        builder.append("memberId=");
        builder.append(this.memberId());
        builder.append('|');
        builder.append("highMemberId=");
        builder.append(this.highMemberId());
        builder.append('|');
        builder.append("clusterMembers=");
        builder.append('\'' + this.clusterMembers() + '\'');
        this.limit(originalLimit);
        return builder;
    }
}

